/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.persistence.legacy;

import com.adobe.cq.dam.cfm.ElementTemplate;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.AbstractFieldManager;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateReader;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateWriter;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.adobe.cq.dam.cfm.openapi.models.DataType;
import com.adobe.cq.dam.cfm.openapi.models.TextModelField;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={ElementTemplateReader.class, ElementTemplateWriter.class})
public class TextFieldManager
extends AbstractFieldManager<TextModelField>
implements ElementTemplateReader {
    public static final String RESOURCE_TYPE = "granite/ui/components/coral/foundation/form/textfield";
    public static final String MULTI_RESOURCE_TYPE = "granite/ui/components/coral/foundation/form/multifield";
    public static final String VALIDATION_REGEX = "validationRegex";
    public static final String CUSTOM_ERROR_MSG = "customErrorMsg";
    public static final String LEGACY_VALIDATION = "cfm.validation.";
    private static final Map<String, Object> DEFAULT_RESOURCE_PROPERTIES = Map.of("jcr:primaryType", "nt:unstructured", "sling:resourceType", "granite/ui/components/coral/foundation/form/textfield", "metaType", "text-single", "renderReadOnly", "false", "showEmptyInReadOnly", "true");
    public static final String LEGACY_VALUE_TYPE = "valueType";

    @Override
    @NotNull
    public Optional<ContentFragmentModelField> convertToDTO(@NotNull ElementTemplate elementTemplate) {
        Resource resource = (Resource)elementTemplate.adaptTo(Resource.class);
        if (resource == null) {
            return Optional.empty();
        }
        TextModelField modelField = new TextModelField();
        ValueMap valueMap = resource.getValueMap();
        modelField.setMaxLength((Integer)valueMap.get("maxlength", Integer.class));
        modelField.setMultiple(elementTemplate.getDataType().isMultiValue());
        modelField.setDefaultValue((String)valueMap.get("value", String.class));
        Resource regexDetailsResource = resource.getChild("granite:data");
        String customRegex = null;
        if (regexDetailsResource != null && regexDetailsResource.getValueMap().containsKey((Object)VALIDATION_REGEX)) {
            ValueMap vm = regexDetailsResource.getValueMap();
            customRegex = (String)vm.get(VALIDATION_REGEX, String.class);
            String errorMessage = (String)vm.get(CUSTOM_ERROR_MSG, String.class);
            modelField.setCustomValidationRegex(customRegex);
            modelField.setCustomErrorMessage(errorMessage);
        }
        if (valueMap.containsKey((Object)"validation")) {
            String validation;
            switch (validation = valueMap.get((Object)"validation").toString()) {
                case "cfm.validation.url": {
                    modelField.setValidationType(TextModelField.ValidationTypeEnum.URL);
                    break;
                }
                case "cfm.validation.email": {
                    modelField.setValidationType(TextModelField.ValidationTypeEnum.EMAIL);
                    break;
                }
                case "cfm.validation.custom": {
                    if (customRegex == null) break;
                    modelField.setValidationType(TextModelField.ValidationTypeEnum.CUSTOM);
                    break;
                }
            }
        }
        return Optional.of(modelField.type(DataType.TEXT));
    }

    @Override
    @NotNull
    protected Pair<Map<String, Object>, Map<String, Object>> generateFieldResourceProperties(@NotNull TextModelField field) {
        Map<String, Object> properties = this.generateMainFieldCommonProperties(field, new HashMap<String, Object>(DEFAULT_RESOURCE_PROPERTIES));
        HashMap<String, Object> graniteDataProperties = new HashMap<String, Object>(DEFAULT_GRANITE_DATA_RESOURCE_PROPERTIES);
        properties.put("maxlength", this.processValue(field.getMaxLength()));
        properties.put("fieldLabel", field.getLabel());
        if (Boolean.TRUE.equals(field.getMultiple())) {
            properties.put(LEGACY_VALUE_TYPE, "string[]");
        } else {
            properties.put(LEGACY_VALUE_TYPE, "string");
        }
        if (!TextModelField.ValidationTypeEnum.NONE.equals((Object)field.getValidationType())) {
            properties.put("validation", LEGACY_VALIDATION + field.getValidationType());
        }
        graniteDataProperties.put(VALIDATION_REGEX, field.getCustomValidationRegex());
        graniteDataProperties.put(CUSTOM_ERROR_MSG, field.getCustomErrorMessage());
        return Pair.of(Map.copyOf(this.removeNullValuesFromProperties(properties)), this.removeNullValuesFromProperties(graniteDataProperties));
    }

    @Override
    @NotNull
    protected Map<String, Object> generateFieldSubResourceProperties(@NotNull TextModelField field) {
        if (Boolean.TRUE.equals(field.getMultiple())) {
            Map<String, Object> properties = this.generateFieldResourceCommonProperties(field, new HashMap<String, Object>(DEFAULT_FIELD_SUB_RESOURCE_PROPERTIES));
            properties.put("emptyText", field.getPlaceholder());
            properties.put("validation", LEGACY_VALIDATION + field.getValidationType().value());
            properties.put("value", field.getDefaultValue());
            properties.put("maxlength", field.getMaxLength());
            return Map.copyOf(this.removeNullValuesFromProperties(properties));
        }
        return Map.of();
    }

    @Override
    @NotNull
    public List<String> getResourceTypes() {
        return List.of(RESOURCE_TYPE);
    }

    @Override
    @NotNull
    public List<String> getDataTypes() {
        return List.of(DataType.TEXT.toString());
    }

    @Override
    @NotNull
    protected Optional<String> getMultiFieldResourceType() {
        return Optional.of(MULTI_RESOURCE_TYPE);
    }
}

