/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.persistence.legacy;

import com.adobe.cq.dam.cfm.ElementTemplate;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.AbstractFieldManager;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateReader;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateWriter;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.resource.ModelItemsResource;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.adobe.cq.dam.cfm.openapi.models.DataType;
import com.adobe.cq.dam.cfm.openapi.models.TagModelField;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={ElementTemplateReader.class, ElementTemplateWriter.class})
public class TagFieldManager
extends AbstractFieldManager<TagModelField>
implements ElementTemplateReader {
    public static final String MULTIPLE = "multiple";
    public static final String RESOURCE_TYPE = "cq/gui/components/coral/common/form/tagfield";
    public static final String LEGACY_ROOT_PATH = "rootPath";
    public static final String LEGACY_AUTOCREATE_TAG = "autocreateTag";
    public static final String LEGACY_CQ_SHOW_ON_CREATE = "cq:showOnCreate";
    public static final String LEGACY_FORCE_SELECTION = "forceSelection";
    public static final Map<String, Object> DEFAULT_RESOURCE_PROPERTIES = Map.of("autocreateTag", "true", "cq:showOnCreate", "true", "forceSelection", "false", "metaType", "tags", "renderReadOnly", "false", "showEmptyInReadOnly", "true", "valueType", "string/tags[]", "sling:resourceType", "cq/gui/components/coral/common/form/tagfield");

    @Override
    @NotNull
    public Optional<ContentFragmentModelField> convertToDTO(@NotNull ElementTemplate elementTemplate) {
        Resource resource = (Resource)elementTemplate.adaptTo(Resource.class);
        if (resource == null) {
            return Optional.empty();
        }
        TagModelField modelField = new TagModelField();
        ValueMap valueMap = resource.getValueMap();
        String rootValue = (String)valueMap.get(LEGACY_ROOT_PATH, String.class);
        if (rootValue != null) {
            modelField.setRoot(rootValue);
        }
        modelField.setMultiple((Boolean)valueMap.get(MULTIPLE, Boolean.class));
        return Optional.of(modelField.type(DataType.TAG));
    }

    @Override
    @NotNull
    public Resource generate(@NotNull ModelItemsResource modelItemsResource, @NotNull TagModelField field) throws PersistenceException {
        Resource fieldResource = modelItemsResource.getResource(field);
        if (fieldResource == null) {
            HashMap<String, Object> properties = new HashMap<String, Object>(DEFAULT_RESOURCE_PROPERTIES);
            this.prepareProperties(field, properties);
            fieldResource = modelItemsResource.getResourceResolver().create((Resource)modelItemsResource, field.getName(), Collections.unmodifiableMap(properties));
        } else {
            ModifiableValueMap properties = (ModifiableValueMap)fieldResource.adaptTo(ModifiableValueMap.class);
            if (properties != null) {
                this.prepareModifiableValueMapForWriting(properties);
                properties.putAll(DEFAULT_RESOURCE_PROPERTIES);
                this.prepareProperties(field, (Map<String, Object>)properties);
            }
        }
        return fieldResource;
    }

    private void prepareProperties(@NotNull TagModelField field, @NotNull Map<String, Object> properties) {
        properties.putAll(this.generateMainFieldCommonProperties(field, properties));
        properties.put(LEGACY_ROOT_PATH, this.processValue(field.getRoot()));
        properties.put("fieldLabel", field.getLabel());
        properties.put(MULTIPLE, Boolean.toString(Boolean.TRUE.equals(field.getMultiple())));
        this.removeNullValuesFromProperties(properties);
    }

    @Override
    public List<String> getResourceTypes() {
        return List.of(RESOURCE_TYPE);
    }

    @Override
    public List<String> getDataTypes() {
        return List.of(DataType.TAG.toString());
    }
}

