/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.persistence.legacy;

import com.adobe.cq.dam.cfm.ElementTemplate;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.AbstractFieldManager;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateReader;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateWriter;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.adobe.cq.dam.cfm.openapi.models.DataType;
import com.adobe.cq.dam.cfm.openapi.models.DoubleNumberModelField;
import com.adobe.cq.dam.cfm.openapi.models.LongNumberModelField;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ElementTemplateReader.class, ElementTemplateWriter.class})
public class NumberFieldManager
extends AbstractFieldManager<ContentFragmentModelField>
implements ElementTemplateReader {
    private static final Logger LOG = LoggerFactory.getLogger(NumberFieldManager.class);
    public static final String RESOURCE_TYPE = "granite/ui/components/coral/foundation/form/numberfield";
    public static final String MULTI_RESOURCE_TYPE = "granite/ui/components/coral/foundation/form/multifield";
    public static final String LEGACY_NUMBER_MIN = "number-min";
    public static final String LEGACY_NUMBER_MAX = "number-max";
    public static final String LEGACY_VALUE = "value";
    public static final String LEGACY_DOUBLE = "double";
    public static final String LEGACY_LONG = "long";
    public static final String LEGACY_NUMBER = "number";
    public static final String LEGACY_STEP = "step";
    public static final String LEGACY_TYPE_HINT = "typeHint";
    public static final String LEGACY_VALIDATION = "validation";
    public static final String LEGACY_VALIDATION_MIN = "cfm.validation.number.min";
    public static final String LEGACY_VALIDATION_MAX = "cfm.validation.number.max";
    public static final String LEGACY_VALIDATION_INTERVAL = "cfm.validation.number.interval";
    public static final Map<String, Object> DEFAULT_RESOURCE_PROPERTIES = Map.of("jcr:primaryType", "nt:unstructured", "sling:resourceType", "granite/ui/components/coral/foundation/form/numberfield", "metaType", "number", "renderReadOnly", "false", "showEmptyInReadOnly", "true", "step", "any");
    private static final Set<String> GRANITE_DATA_PROPERTIES = Set.of("number-min", "number-max");

    @Override
    @NotNull
    public Optional<ContentFragmentModelField> convertToDTO(@NotNull ElementTemplate elementTemplate) {
        String numberType;
        Resource resource = (Resource)elementTemplate.adaptTo(Resource.class);
        if (resource == null) {
            return Optional.empty();
        }
        ValueMapDecorator legacyMap = new ValueMapDecorator(new HashMap());
        legacyMap.putAll((Map)resource.getValueMap());
        Resource graniteData = resource.getChild("granite:data");
        if (graniteData != null) {
            for (Map.Entry graniteDataEntry : graniteData.getValueMap().entrySet()) {
                legacyMap.putIfAbsent((Object)((String)graniteDataEntry.getKey()), graniteDataEntry.getValue());
            }
        }
        if ((numberType = elementTemplate.getDataType().getValueType()).equals(LEGACY_LONG)) {
            return Optional.of(new LongNumberModelField().defaultValue((Long)legacyMap.get(LEGACY_VALUE, Long.class)).min((Long)legacyMap.get(LEGACY_NUMBER_MIN, Long.class)).max((Long)legacyMap.get(LEGACY_NUMBER_MAX, Long.class)).type(DataType.NUMBER).multiple(elementTemplate.getDataType().isMultiValue()));
        }
        if (numberType.equals(LEGACY_DOUBLE)) {
            return Optional.of(new DoubleNumberModelField().defaultValue((Double)legacyMap.get(LEGACY_VALUE, Double.class)).min((Double)legacyMap.get(LEGACY_NUMBER_MIN, Double.class)).max((Double)legacyMap.get(LEGACY_NUMBER_MAX, Double.class)).type(DataType.FLOAT_NUMBER).multiple(elementTemplate.getDataType().isMultiValue()));
        }
        LOG.error("Unknown number type {} for model field {}.", (Object)numberType, (Object)resource.getPath());
        return Optional.empty();
    }

    @Override
    @NotNull
    protected Pair<Map<String, Object>, Map<String, Object>> generateFieldResourceProperties(@NotNull ContentFragmentModelField field) {
        ContentFragmentModelField modelField;
        Map<String, Object> mainProperties = this.generateMainFieldCommonProperties(field, DEFAULT_RESOURCE_PROPERTIES);
        if (field instanceof LongNumberModelField) {
            modelField = (LongNumberModelField)field;
            mainProperties.put(LEGACY_NUMBER_MIN, this.processValue(((LongNumberModelField)modelField).getMin()));
            mainProperties.put(LEGACY_NUMBER_MAX, this.processValue(((LongNumberModelField)modelField).getMax()));
            mainProperties.put(LEGACY_VALUE, this.processValue(((LongNumberModelField)modelField).getDefaultValue()));
        } else if (field instanceof DoubleNumberModelField) {
            modelField = (DoubleNumberModelField)field;
            mainProperties.put(LEGACY_NUMBER_MIN, this.processValue(((DoubleNumberModelField)modelField).getMin()));
            mainProperties.put(LEGACY_NUMBER_MAX, this.processValue(((DoubleNumberModelField)modelField).getMax()));
            mainProperties.put(LEGACY_VALUE, this.processValue(((DoubleNumberModelField)modelField).getDefaultValue()));
        }
        mainProperties.put("fieldLabel", field.getLabel());
        mainProperties = this.removeNullValuesFromProperties(mainProperties);
        HashMap<String, Object> graniteDataProperties = new HashMap<String, Object>(DEFAULT_GRANITE_DATA_RESOURCE_PROPERTIES);
        graniteDataProperties.putAll(mainProperties.entrySet().stream().filter(entry -> GRANITE_DATA_PROPERTIES.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        for (String key : GRANITE_DATA_PROPERTIES) {
            mainProperties.remove(key);
        }
        if (Boolean.TRUE.equals(field.getMultiple())) {
            if (field.getType() == DataType.NUMBER) {
                mainProperties.put("valueType", "long[]");
                mainProperties.put(LEGACY_TYPE_HINT, LEGACY_LONG);
            } else if (field.getType() == DataType.FLOAT_NUMBER) {
                mainProperties.put("valueType", "double[]");
                mainProperties.put(LEGACY_TYPE_HINT, LEGACY_DOUBLE);
            }
        } else if (field.getType() == DataType.NUMBER) {
            mainProperties.put("valueType", LEGACY_LONG);
            mainProperties.put(LEGACY_TYPE_HINT, LEGACY_LONG);
        } else if (field.getType() == DataType.FLOAT_NUMBER) {
            mainProperties.put("valueType", LEGACY_DOUBLE);
            mainProperties.put(LEGACY_TYPE_HINT, LEGACY_DOUBLE);
        }
        if (graniteDataProperties.containsKey(LEGACY_NUMBER_MIN) && graniteDataProperties.containsKey(LEGACY_NUMBER_MAX)) {
            mainProperties.put(LEGACY_VALIDATION, LEGACY_VALIDATION_INTERVAL);
        } else if (graniteDataProperties.containsKey(LEGACY_NUMBER_MIN)) {
            mainProperties.put(LEGACY_VALIDATION, LEGACY_VALIDATION_MIN);
        } else if (graniteDataProperties.containsKey(LEGACY_NUMBER_MAX)) {
            mainProperties.put(LEGACY_VALIDATION, LEGACY_VALIDATION_MAX);
        }
        return Pair.of(Map.copyOf(this.removeNullValuesFromProperties(mainProperties)), Map.copyOf(this.removeNullValuesFromProperties(graniteDataProperties)));
    }

    @Override
    @NotNull
    protected Map<String, Object> generateFieldSubResourceProperties(@NotNull ContentFragmentModelField field) {
        if (Boolean.TRUE.equals(field.getMultiple())) {
            Map<String, Object> properties = this.generateFieldResourceCommonProperties(field, new HashMap<String, Object>(DEFAULT_FIELD_SUB_RESOURCE_PROPERTIES));
            if (field instanceof LongNumberModelField) {
                LongNumberModelField longNumberModelField = (LongNumberModelField)field;
                properties.put("emptyText", longNumberModelField.getPlaceholder());
                properties.put(LEGACY_VALUE, longNumberModelField.getDefaultValue());
                if (longNumberModelField.getMin() != null && longNumberModelField.getMax() != null) {
                    properties.put(LEGACY_VALIDATION, LEGACY_VALIDATION_INTERVAL);
                } else if (longNumberModelField.getMin() != null) {
                    properties.put(LEGACY_VALIDATION, LEGACY_VALIDATION_MIN);
                } else if (longNumberModelField.getMax() != null) {
                    properties.put(LEGACY_VALIDATION, LEGACY_VALIDATION_MAX);
                }
            } else if (field instanceof DoubleNumberModelField) {
                DoubleNumberModelField floatNumberModelField = (DoubleNumberModelField)field;
                properties.put("emptyText", floatNumberModelField.getPlaceholder());
                properties.put(LEGACY_VALUE, floatNumberModelField.getDefaultValue());
                if (floatNumberModelField.getMin() != null && floatNumberModelField.getMax() != null) {
                    properties.put(LEGACY_VALIDATION, LEGACY_VALIDATION_INTERVAL);
                } else if (floatNumberModelField.getMin() != null) {
                    properties.put(LEGACY_VALIDATION, LEGACY_VALIDATION_MIN);
                } else if (floatNumberModelField.getMax() != null) {
                    properties.put(LEGACY_VALIDATION, LEGACY_VALIDATION_MAX);
                }
            }
            return Map.copyOf(this.removeNullValuesFromProperties(properties));
        }
        return Map.of();
    }

    @Override
    @NotNull
    public List<String> getResourceTypes() {
        return List.of(RESOURCE_TYPE);
    }

    @Override
    @NotNull
    public List<String> getDataTypes() {
        return List.of(DataType.NUMBER.toString(), DataType.FLOAT_NUMBER.toString());
    }

    @Override
    @NotNull
    protected Optional<String> getMultiFieldResourceType() {
        return Optional.of(MULTI_RESOURCE_TYPE);
    }
}

