/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.persistence.legacy;

import com.adobe.cq.dam.cfm.DataType;
import com.adobe.cq.dam.cfm.ElementTemplate;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateReader;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.FieldManagerRegistry;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true)
public class MultiFieldElementTemplateReader
implements ElementTemplateReader {
    private FieldManagerRegistry registry;

    @Override
    public Optional<ContentFragmentModelField> convertToDTO(@NotNull ElementTemplate elementTemplate) {
        Resource resource = (Resource)elementTemplate.adaptTo(Resource.class);
        if (resource == null) {
            return Optional.empty();
        }
        Resource field = resource.getChild("field");
        if (field == null || this.registry == null) {
            return Optional.empty();
        }
        ElementTemplateWrapper wrapper = new ElementTemplateWrapper(elementTemplate, new ElementTemplateWrapperResource(resource, field));
        ElementTemplateReader reader = this.registry.getReader(wrapper);
        if (reader == null) {
            return Optional.empty();
        }
        return reader.convertToDTO(wrapper);
    }

    @Override
    public List<String> getResourceTypes() {
        return List.of("granite/ui/components/coral/foundation/form/multifield", "dam/cfm/admin/components/authoring/contenteditor/cfmmultifield", "dam/cfm/models/editor/components/fragmentreference/multifield");
    }

    @Override
    public void injectRegistry(@NotNull FieldManagerRegistry registry) {
        this.registry = registry;
    }

    private static class ElementTemplateWrapperResource
    extends ResourceWrapper {
        private final Resource elementTemplateResource;
        private final Resource fieldResource;
        private ValueMap valueMap;

        public ElementTemplateWrapperResource(@NotNull Resource elementTemplateResource, @NotNull Resource fieldResource) {
            super(elementTemplateResource);
            this.fieldResource = fieldResource;
            this.elementTemplateResource = elementTemplateResource;
        }

        public <AdapterType> AdapterType adaptTo(@NotNull Class<AdapterType> type) {
            if (type == ValueMap.class) {
                return (AdapterType)this.prepareOrGetValueMap();
            }
            return (AdapterType)super.adaptTo(type);
        }

        @NotNull
        public String getResourceType() {
            return this.fieldResource.getResourceType();
        }

        @NotNull
        public ValueMap getValueMap() {
            return this.prepareOrGetValueMap();
        }

        private ValueMap prepareOrGetValueMap() {
            if (this.valueMap == null) {
                this.valueMap = new ValueMapDecorator(new HashMap(this.elementTemplateResource.getValueMap()));
                this.valueMap.putAll((Map)this.fieldResource.getValueMap());
            }
            return this.valueMap;
        }
    }

    private static class ElementTemplateWrapper
    implements ElementTemplate {
        private final ElementTemplate wrapped;
        private final Resource resource;

        public ElementTemplateWrapper(@NotNull ElementTemplate wrapped, @NotNull ElementTemplateWrapperResource resource) {
            this.wrapped = wrapped;
            this.resource = resource;
        }

        public String getName() {
            return this.wrapped.getName();
        }

        public String getTitle() {
            return this.wrapped.getTitle();
        }

        @NotNull
        public DataType getDataType() {
            return this.wrapped.getDataType();
        }

        @Nullable
        public String getInitialContentType() {
            return this.wrapped.getInitialContentType();
        }

        @Nullable
        public String getDefaultContent() {
            return this.wrapped.getDefaultContent();
        }

        public Map<String, Object> getMetaData() {
            return this.wrapped.getMetaData();
        }

        @Nullable
        public <AdapterType> AdapterType adaptTo(@NotNull Class<AdapterType> type) {
            if (type == Resource.class) {
                return (AdapterType)this.resource;
            }
            return (AdapterType)this.wrapped.adaptTo(type);
        }
    }
}

