/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.persistence.legacy;

import com.adobe.cq.dam.cfm.ElementTemplate;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.AbstractFieldManager;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateReader;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateWriter;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.adobe.cq.dam.cfm.openapi.models.DataType;
import com.adobe.cq.dam.cfm.openapi.models.LongTextModelField;
import com.adobe.cq.dam.cfm.openapi.models.MimeType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={ElementTemplateReader.class, ElementTemplateWriter.class})
public class LongTextFieldManager
extends AbstractFieldManager<LongTextModelField>
implements ElementTemplateReader {
    public static final String LEGACY_MIME_TYPE = "default-mime-type";
    public static final String RESOURCE_TYPE = "dam/cfm/admin/components/authoring/contenteditor/multieditor";
    public static final String MULTI_RESOURCE_TYPE = "dam/cfm/admin/components/authoring/contenteditor/cfmmultifield";
    private static final Map<String, Object> DEFAULT_RESOURCE_PROPERTIES = Map.of("jcr:primaryType", "nt:unstructured", "sling:resourceType", "dam/cfm/admin/components/authoring/contenteditor/multieditor", "metaType", "text-multi", "renderReadOnly", "false", "showEmptyInReadOnly", "true", "valueType", "string/multiline");

    @Override
    @NotNull
    public Optional<ContentFragmentModelField> convertToDTO(@NotNull ElementTemplate elementTemplate) {
        Resource resource = (Resource)elementTemplate.adaptTo(Resource.class);
        if (resource == null) {
            return Optional.empty();
        }
        LongTextModelField modelField = new LongTextModelField();
        String contentType = elementTemplate.getInitialContentType();
        if (StringUtils.isNotEmpty((CharSequence)contentType)) {
            try {
                modelField.setMimeType(MimeType.fromValue(contentType));
            }
            catch (IllegalArgumentException exception) {
                this.logger.error("Field {} has an invalid mime-type: {}.", (Object)resource.getPath(), (Object)contentType);
            }
        }
        modelField.setMultiple(elementTemplate.getDataType().isMultiValue());
        return Optional.of(modelField.type(DataType.LONG_TEXT));
    }

    @Override
    @NotNull
    protected Optional<String> getMultiFieldResourceType() {
        return Optional.of(MULTI_RESOURCE_TYPE);
    }

    @Override
    @NotNull
    protected Pair<Map<String, Object>, Map<String, Object>> generateFieldResourceProperties(@NotNull LongTextModelField field) {
        Map<String, Object> properties = this.generateMainFieldCommonProperties(field, DEFAULT_RESOURCE_PROPERTIES);
        properties.put(LEGACY_MIME_TYPE, this.processValue(field.getMimeType().toString()));
        properties.put("cfm-element", field.getLabel());
        if (Boolean.TRUE.equals(field.getMultiple())) {
            properties.put("valueType", "string/multiline[]");
        } else {
            properties.put("valueType", "string/multiline");
        }
        return Pair.of(Map.copyOf(this.removeNullValuesFromProperties(properties)), (Object)DEFAULT_GRANITE_DATA_RESOURCE_PROPERTIES);
    }

    @Override
    @NotNull
    protected Map<String, Object> generateFieldSubResourceProperties(@NotNull LongTextModelField field) {
        if (Boolean.TRUE.equals(field.getMultiple())) {
            Map<String, Object> properties = this.generateFieldResourceCommonProperties(field, new HashMap<String, Object>(DEFAULT_FIELD_SUB_RESOURCE_PROPERTIES));
            return Map.copyOf(this.removeNullValuesFromProperties(properties));
        }
        return Map.of();
    }

    @Override
    @NotNull
    public List<String> getResourceTypes() {
        return List.of(RESOURCE_TYPE);
    }

    @Override
    @NotNull
    public List<String> getDataTypes() {
        return List.of(DataType.LONG_TEXT.toString());
    }
}

