/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.persistence.legacy;

import com.adobe.cq.dam.cfm.ElementTemplate;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.AbstractFieldManager;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateReader;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateWriter;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.adobe.cq.dam.cfm.openapi.models.DataType;
import com.adobe.cq.dam.cfm.openapi.models.JsonModelField;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={ElementTemplateReader.class, ElementTemplateWriter.class})
public class JSONFieldWriter
extends AbstractFieldManager<JsonModelField>
implements ElementTemplateReader {
    public static final String RESOURCE_TYPE = "dam/cfm/admin/components/authoring/contenteditor/jsoneditor";
    public static final Map<String, Object> DEFAULT_RESOURCE_PROPERTIES = Map.of("jcr:primaryType", "nt:unstructured", "sling:resourceType", "dam/cfm/admin/components/authoring/contenteditor/jsoneditor", "metaType", "json", "renderReadOnly", "false", "showEmptyInReadOnly", "true", "valueType", "string/json");

    @Override
    @NotNull
    public Optional<ContentFragmentModelField> convertToDTO(@NotNull ElementTemplate elementTemplate) {
        return Optional.of(new JsonModelField().type(DataType.JSON).multiple(elementTemplate.getDataType().isMultiValue()));
    }

    @Override
    @NotNull
    protected Pair<Map<String, Object>, Map<String, Object>> generateFieldResourceProperties(@NotNull JsonModelField field) {
        HashMap<String, Object> mainProperties = new HashMap<String, Object>(DEFAULT_RESOURCE_PROPERTIES);
        mainProperties.putAll(this.generateMainFieldCommonProperties(field, mainProperties));
        mainProperties.put("cfm-element", field.getLabel());
        return Pair.of(Map.copyOf(this.removeNullValuesFromProperties(mainProperties)), Map.of());
    }

    @Override
    @NotNull
    public List<String> getResourceTypes() {
        return List.of(RESOURCE_TYPE);
    }

    @Override
    @NotNull
    public List<String> getDataTypes() {
        return List.of(DataType.JSON.toString());
    }
}

