/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.persistence.legacy;

import com.adobe.cq.dam.cfm.ElementTemplate;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.AbstractFieldManager;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateReader;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateWriter;
import com.adobe.cq.dam.cfm.impl.util.Base64URLHelper;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.adobe.cq.dam.cfm.openapi.models.DataType;
import com.adobe.cq.dam.cfm.openapi.models.FragmentReferenceModelField;
import com.adobe.granite.toggle.api.ToggleRouter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ElementTemplateReader.class, ElementTemplateWriter.class})
public class FragmentReferenceFieldManager
extends AbstractFieldManager<FragmentReferenceModelField>
implements ElementTemplateReader {
    public static final String RESOURCE_TYPE = "dam/cfm/models/editor/components/fragmentreference";
    public static final String MULTI_RESOURCE_TYPE = "dam/cfm/models/editor/components/fragmentreference/multifield";
    public static final String LEGACY_FRAGMENT_MODEL_REFERENCE = "fragmentmodelreference";
    public static final String LEGACY_FRAGMENT_MODEL_REFERENCE_BY_TAG = "fragmentmodelreferencebytag";
    public static final String LEGACY_ROOT_PATH = "rootPath";
    public static final String LEGACY_ALLOW_NEW = "allowNew";
    public static final String LEGACY_FILTER = "filter";
    public static final String LEGACY_VALUE = "value";
    @Reference
    private ToggleRouter toggleRouter;
    public static final Map<String, Object> DEFAULT_RESOURCE_PROPERTIES = Map.of("allowNew", true, "filter", "hierarchy", "jcr:primaryType", "nt:unstructured", "sling:resourceType", "dam/cfm/models/editor/components/fragmentreference", "metaType", "fragment-reference", "renderReadOnly", "false", "showEmptyInReadOnly", "true");
    private static final Set<String> GRANITE_DATA_PROPERTIES = Set.of("mvmaxitems", "mvminitems");

    @Override
    @NotNull
    public Optional<ContentFragmentModelField> convertToDTO(@NotNull ElementTemplate elementTemplate) {
        List<String> referenceTagsList;
        List<String> items;
        String[] references;
        Resource resource = (Resource)elementTemplate.adaptTo(Resource.class);
        if (resource == null) {
            return Optional.empty();
        }
        FragmentReferenceModelField modelField = new FragmentReferenceModelField().items(List.of()).tags(List.of());
        ValueMap valueMap = resource.getValueMap();
        if (valueMap.containsKey((Object)LEGACY_VALUE)) {
            modelField.setDefaultValue((String)valueMap.get(LEGACY_VALUE, String.class));
        }
        if (valueMap.containsKey((Object)LEGACY_ALLOW_NEW)) {
            modelField.setAllowFragmentCreation((Boolean)valueMap.get(LEGACY_ALLOW_NEW, Boolean.class));
        }
        if ((references = (String[])valueMap.get(LEGACY_FRAGMENT_MODEL_REFERENCE, String[].class)) != null && !(items = Arrays.stream(references).map(String::trim).filter(StringUtils::isNotEmpty).map(Base64URLHelper::toId).collect(Collectors.toUnmodifiableList())).isEmpty()) {
            modelField.setItems(items);
        }
        String[] referenceTags = (String[])valueMap.get(LEGACY_FRAGMENT_MODEL_REFERENCE_BY_TAG, String[].class);
        if (this.toggleRouter.isEnabled("FT_SITES-11210") && referenceTags != null && !(referenceTagsList = Arrays.stream(referenceTags).map(String::trim).filter(StringUtils::isNotEmpty).collect(Collectors.toUnmodifiableList())).isEmpty()) {
            modelField.setTags(referenceTagsList);
        }
        modelField.setMultiple(elementTemplate.getDataType().isMultiValue());
        return Optional.of(modelField.type(DataType.CONTENT_FRAGMENT));
    }

    @Override
    @NotNull
    protected Pair<Map<String, Object>, Map<String, Object>> generateFieldResourceProperties(@NotNull FragmentReferenceModelField field) {
        Map<String, Object> main = new HashMap<String, Object>(DEFAULT_RESOURCE_PROPERTIES);
        main.putAll(this.generateMainFieldCommonProperties(field, main));
        main.put("fieldLabel", field.getLabel());
        main.put(LEGACY_ROOT_PATH, this.processValue(field.getRoot()));
        main.put(LEGACY_VALUE, this.processValue(field.getDefaultValue()));
        main.put(LEGACY_ALLOW_NEW, field.getAllowFragmentCreation());
        if (field.getItems() != null) {
            main.put(LEGACY_FRAGMENT_MODEL_REFERENCE, field.getItems().stream().map(String::trim).filter(StringUtils::isNotEmpty).map(Base64URLHelper::toPath).toArray(String[]::new));
        }
        if (field.getTags() != null) {
            main.put(LEGACY_FRAGMENT_MODEL_REFERENCE_BY_TAG, field.getTags().stream().map(String::trim).filter(StringUtils::isNotEmpty).toArray(String[]::new));
        }
        if (Boolean.TRUE.equals(field.getMultiple())) {
            main.put("valueType", "string/content-fragment[]");
        } else {
            main.put("valueType", "string/content-fragment");
        }
        main = this.removeNullValuesFromProperties(main);
        HashMap<String, Object> graniteDataProperties = new HashMap<String, Object>(DEFAULT_GRANITE_DATA_RESOURCE_PROPERTIES);
        graniteDataProperties.putAll(main.entrySet().stream().filter(entry -> GRANITE_DATA_PROPERTIES.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        for (String key : GRANITE_DATA_PROPERTIES) {
            main.remove(key);
        }
        return Pair.of(Map.copyOf(this.removeNullValuesFromProperties(main)), Map.copyOf(this.removeNullValuesFromProperties(graniteDataProperties)));
    }

    @Override
    @NotNull
    protected Map<String, Object> generateFieldSubResourceProperties(@NotNull FragmentReferenceModelField field) {
        if (Boolean.TRUE.equals(field.getMultiple())) {
            Map<String, Object> properties = this.generateFieldResourceCommonProperties(field, new HashMap<String, Object>(DEFAULT_FIELD_SUB_RESOURCE_PROPERTIES));
            properties.put("emptyText", field.getPlaceholder());
            properties.put(LEGACY_VALUE, field.getDefaultValue());
            properties.put(LEGACY_ROOT_PATH, field.getRoot());
            if (field.getItems() != null) {
                properties.put(LEGACY_FRAGMENT_MODEL_REFERENCE, field.getItems().stream().map(String::trim).filter(StringUtils::isNotEmpty).map(Base64URLHelper::toPath).toArray(String[]::new));
            }
            if (field.getTags() != null) {
                properties.put(LEGACY_FRAGMENT_MODEL_REFERENCE_BY_TAG, field.getTags().stream().map(String::trim).filter(StringUtils::isNotEmpty).toArray(String[]::new));
            }
            return Map.copyOf(this.removeNullValuesFromProperties(properties));
        }
        return Map.of();
    }

    @Override
    @NotNull
    protected Optional<String> getMultiFieldResourceType() {
        return Optional.of(MULTI_RESOURCE_TYPE);
    }

    @Override
    @NotNull
    public List<String> getResourceTypes() {
        return List.of(RESOURCE_TYPE);
    }

    @Override
    @NotNull
    public List<String> getDataTypes() {
        return List.of(DataType.CONTENT_FRAGMENT.toString());
    }
}

