/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.persistence.legacy;

import com.adobe.cq.dam.cfm.ElementTemplate;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateReader;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateWriter;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.adobe.cq.dam.cfm.openapi.models.DataType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FieldManagerRegistry.class})
public class FieldManagerRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldManagerRegistry.class);
    private final Map<String, ServiceHolder<ElementTemplateReader>> readerRegistry = new ConcurrentHashMap<String, ServiceHolder<ElementTemplateReader>>();
    private final Map<String, ServiceHolder<ElementTemplateWriter<ContentFragmentModelField>>> writerRegistry = new ConcurrentHashMap<String, ServiceHolder<ElementTemplateWriter<ContentFragmentModelField>>>();

    @Nullable
    public ElementTemplateReader getReader(@NotNull ElementTemplate elementTemplate) {
        Resource resource = (Resource)elementTemplate.adaptTo(Resource.class);
        if (resource != null) {
            ServiceHolder<ElementTemplateReader> readerService = this.readerRegistry.get(resource.getResourceType());
            if (readerService != null) {
                return (ElementTemplateReader)readerService.service;
            }
            String resourceSuperType = resource.getResourceSuperType();
            if (StringUtils.isNotEmpty((CharSequence)resourceSuperType) && (readerService = this.readerRegistry.get(resourceSuperType)) != null) {
                return (ElementTemplateReader)readerService.service;
            }
        }
        return null;
    }

    @Nullable
    public ElementTemplateWriter<ContentFragmentModelField> getWriter(@NotNull DataType dataType) {
        ServiceHolder<ElementTemplateWriter<ContentFragmentModelField>> serviceHolder = this.writerRegistry.get(dataType.toString());
        if (serviceHolder != null) {
            return (ElementTemplateWriter)serviceHolder.service;
        }
        return null;
    }

    @Reference(service=ElementTemplateReader.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindElementTemplateReader(@NotNull ServiceReference<ElementTemplateReader> serviceReference, @NotNull ElementTemplateReader elementTemplateReader) {
        for (String resourceType : elementTemplateReader.getResourceTypes()) {
            if (!StringUtils.isNotEmpty((CharSequence)resourceType)) continue;
            ServiceHolder<ElementTemplateReader> previous = this.readerRegistry.get(resourceType);
            ServiceHolder<ElementTemplateReader> newer = new ServiceHolder<ElementTemplateReader>(serviceReference, elementTemplateReader);
            if (previous == null) {
                this.readerRegistry.put(resourceType, newer);
                elementTemplateReader.injectRegistry(this);
                continue;
            }
            if (previous.serviceReference.compareTo(serviceReference) < 0) {
                this.readerRegistry.put(resourceType, newer);
                elementTemplateReader.injectRegistry(this);
                LOGGER.info("Replaced ElementTemplateReader {} with {} since it had a higher service.ranking.", (Object)((ElementTemplateReader)previous.service).getClass().getName(), (Object)((ElementTemplateReader)newer.service).getClass().getName());
                continue;
            }
            LOGGER.info("ElementTemplateReader {} has a lower service.ranking than the already registered {}.", (Object)((ElementTemplateReader)newer.service).getClass().getName(), (Object)((ElementTemplateReader)previous.service).getClass().getName());
        }
    }

    public void unbindElementTemplateReader(@NotNull ServiceReference<ElementTemplateReader> serviceReference, @NotNull ElementTemplateReader elementTemplateReader) {
        for (String resourceType : elementTemplateReader.getResourceTypes()) {
            ServiceHolder<ElementTemplateReader> previous;
            if (!StringUtils.isNotEmpty((CharSequence)resourceType) || (previous = this.readerRegistry.get(resourceType)) == null || !previous.serviceReference.equals(serviceReference)) continue;
            this.readerRegistry.remove(resourceType);
        }
    }

    @Reference(service=ElementTemplateWriter.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindElementTemplateWriter(@NotNull ServiceReference<ElementTemplateWriter<ContentFragmentModelField>> serviceReference, @NotNull ElementTemplateWriter<ContentFragmentModelField> elementTemplateWriter) {
        for (String dataType : elementTemplateWriter.getDataTypes()) {
            if (!StringUtils.isNotEmpty((CharSequence)dataType)) continue;
            ServiceHolder<ElementTemplateWriter<ContentFragmentModelField>> previous = this.writerRegistry.get(dataType);
            ServiceHolder<ElementTemplateWriter<ContentFragmentModelField>> newer = new ServiceHolder<ElementTemplateWriter<ContentFragmentModelField>>(serviceReference, elementTemplateWriter);
            if (previous == null) {
                this.writerRegistry.put(dataType, newer);
                continue;
            }
            if (previous.serviceReference.compareTo(serviceReference) < 0) {
                this.writerRegistry.put(dataType, newer);
                LOGGER.info("Replaced ElementTemplateWriter {} with {} since it had a higher service.ranking.", (Object)((ElementTemplateWriter)previous.service).getClass().getName(), (Object)((ElementTemplateWriter)newer.service).getClass().getName());
                continue;
            }
            LOGGER.info("ElementTemplateWriter {} has a lower service.ranking than the already registered {}.", (Object)((ElementTemplateWriter)newer.service).getClass().getName(), (Object)((ElementTemplateWriter)previous.service).getClass().getName());
        }
    }

    public void unbindElementTemplateWriter(@NotNull ServiceReference<ElementTemplateWriter<?>> serviceReference, @NotNull ElementTemplateWriter<?> elementTemplateWriter) {
        for (String dataType : elementTemplateWriter.getDataTypes()) {
            ServiceHolder<ElementTemplateWriter<ContentFragmentModelField>> previous;
            if (!StringUtils.isNotEmpty((CharSequence)dataType) || (previous = this.writerRegistry.get(dataType)) == null || !previous.serviceReference.equals(serviceReference)) continue;
            this.writerRegistry.remove(dataType);
        }
    }

    private static class ServiceHolder<T> {
        private final ServiceReference<T> serviceReference;
        private final T service;

        public ServiceHolder(ServiceReference<T> serviceReference, T service) {
            this.serviceReference = serviceReference;
            this.service = service;
        }
    }
}

