/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.persistence.legacy;

import com.adobe.cq.dam.cfm.ElementTemplate;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.AbstractFieldManager;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateReader;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateWriter;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.resource.ModelItemsResource;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.adobe.cq.dam.cfm.openapi.models.DataType;
import com.adobe.cq.dam.cfm.openapi.models.EnumerationModelField;
import com.adobe.cq.dam.cfm.openapi.models.EnumerationModelFieldAllOfValues;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={ElementTemplateReader.class, ElementTemplateWriter.class})
public class EnumerationFieldManager
extends AbstractFieldManager<EnumerationModelField>
implements ElementTemplateReader {
    public static final String METADATA_KEY = "key";
    public static final String METADATA_VALUE = "value";
    public static final String LEGACY_OPTIONS_MULTIFIELD = "optionsmultifield";
    public static final String LEGACY_OPTIONS_PROPERTY = "options";
    public static final String LEGACY_DATASOURCE_NODE = "datasource";
    public static final String LEGACY_FIELD_LABEL = "fieldLabel";
    public static final String LEGACY_FIELD_VALUE = "fieldValue";
    public static final String LEGACY_EMPTY_OPTION = "emptyOption";
    public static final String RESOURCE_TYPE_SELECT = "granite/ui/components/coral/foundation/form/select";
    public static final String RESOURCE_TYPE_CHECKBOX = "dam/cfm/admin/components/authoring/contenteditor/multicheckbox";
    public static final String RESOURCE_TYPE_RADIO = "granite/ui/components/coral/foundation/form/radiogroup";
    public static final Map<String, Object> DEFAULT_RESOURCE_PROPERTIES = Map.of("emptyOption", true, "jcr:primaryType", "nt:unstructured", "metaType", "enumeration", "renderReadOnly", "false", "showEmptyInReadOnly", "true", "valueType", "string");
    public static final String DS_OPTION_RENDERER = "dam/cfm/admin/components/datasources/optionrenderer";
    public static final String DS_OPTION_RENDERER_MULTIFIELD = "dam/cfm/admin/components/datasources/optionrendererenumeration";
    static final BiMap<EnumerationModelField.HintEnum, String> HINT_TO_RESOURCE_TYPE_MAPPING = new ImmutableBiMap.Builder().put((Object)EnumerationModelField.HintEnum.RADIO, (Object)"granite/ui/components/coral/foundation/form/radiogroup").put((Object)EnumerationModelField.HintEnum.SELECT, (Object)"granite/ui/components/coral/foundation/form/select").put((Object)EnumerationModelField.HintEnum.CHECKBOX, (Object)"dam/cfm/admin/components/authoring/contenteditor/multicheckbox").build();

    @Override
    @NotNull
    public Optional<ContentFragmentModelField> convertToDTO(@NotNull ElementTemplate elementTemplate) {
        EnumerationModelField.HintEnum hint;
        Resource resource = (Resource)elementTemplate.adaptTo(Resource.class);
        if (resource == null) {
            return Optional.empty();
        }
        EnumerationModelField modelField = new EnumerationModelField();
        Resource datasource = resource.getChild(LEGACY_DATASOURCE_NODE);
        if (datasource != null) {
            modelField.setValues(this.extractEnumerationValues(resource, datasource));
        }
        if ((hint = (EnumerationModelField.HintEnum)((Object)HINT_TO_RESOURCE_TYPE_MAPPING.inverse().get((Object)resource.getResourceType()))) == null) {
            return Optional.empty();
        }
        modelField.setMultiple(elementTemplate.getDataType().isMultiValue());
        return Optional.of(modelField.hint(hint).type(DataType.ENUMERATION));
    }

    @Override
    @NotNull
    public Resource generate(@NotNull ModelItemsResource modelItemsResource, @NotNull EnumerationModelField field) throws PersistenceException {
        Resource fieldResource = modelItemsResource.getResource(field);
        if (fieldResource == null) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            this.prepareProperties(field, properties);
            fieldResource = modelItemsResource.getResourceResolver().create((Resource)modelItemsResource, field.getName(), Collections.unmodifiableMap(properties));
            List<Map<String, String>> enumerationValues = field.getValues().stream().map(enumerationValue -> Map.of(METADATA_KEY, enumerationValue.getKey(), METADATA_VALUE, enumerationValue.getValue())).collect(Collectors.toList());
            this.persistEnumerationValues(modelItemsResource, fieldResource, enumerationValues);
        } else {
            ModifiableValueMap properties = (ModifiableValueMap)fieldResource.adaptTo(ModifiableValueMap.class);
            if (properties != null) {
                this.prepareModifiableValueMapForWriting(properties);
                this.prepareProperties(field, (Map<String, Object>)properties);
                List<Map<String, String>> enumerationValues = field.getValues().stream().map(enumerationValue -> Map.of(METADATA_KEY, enumerationValue.getKey(), METADATA_VALUE, enumerationValue.getValue())).collect(Collectors.toList());
                if (!enumerationValues.isEmpty()) {
                    Resource datasource = fieldResource.getChild(LEGACY_DATASOURCE_NODE);
                    if (datasource != null) {
                        modelItemsResource.getResourceResolver().delete(datasource);
                    }
                    this.persistEnumerationValues(modelItemsResource, fieldResource, enumerationValues);
                } else {
                    Resource optionsmultifield;
                    Resource datasource = fieldResource.getChild(LEGACY_DATASOURCE_NODE);
                    if (datasource != null) {
                        modelItemsResource.getResourceResolver().delete(datasource);
                    }
                    if ((optionsmultifield = fieldResource.getChild(LEGACY_OPTIONS_MULTIFIELD)) != null) {
                        modelItemsResource.getResourceResolver().delete(optionsmultifield);
                    }
                }
            }
        }
        return fieldResource;
    }

    private void persistEnumerationValues(@NotNull ModelItemsResource modelItemsResource, Resource fieldResource, List<Map<String, String>> enumerationValues) throws PersistenceException {
        if (enumerationValues != null && !enumerationValues.isEmpty()) {
            ResourceUtil.getOrCreateResource((ResourceResolver)modelItemsResource.getResourceResolver(), (String)(fieldResource.getPath() + "/datasource"), Map.of("jcr:primaryType", "nt:unstructured", "sling:resourceType", DS_OPTION_RENDERER_MULTIFIELD, "variant", "default"), (String)"nt:unstructured", (boolean)false);
            Resource optionsmultifield = ResourceUtil.getOrCreateResource((ResourceResolver)modelItemsResource.getResourceResolver(), (String)(fieldResource.getPath() + "/optionsmultifield"), Map.of("jcr:primaryType", "nt:unstructured"), (String)"nt:unstructured", (boolean)false);
            int index = 0;
            for (Resource resource : optionsmultifield.getChildren()) {
                modelItemsResource.getResourceResolver().delete(resource);
            }
            for (Map map : enumerationValues) {
                ResourceUtil.getOrCreateResource((ResourceResolver)modelItemsResource.getResourceResolver(), (String)(optionsmultifield.getPath() + "/item" + index++), Map.of("jcr:primaryType", "nt:unstructured", LEGACY_FIELD_LABEL, map.get(METADATA_KEY), LEGACY_FIELD_VALUE, map.get(METADATA_VALUE)), (String)"nt:unstructured", (boolean)false);
            }
        }
    }

    @NotNull
    private List<EnumerationModelFieldAllOfValues> extractEnumerationValues(@NotNull Resource fieldResource, @NotNull Resource datasource) {
        Resource optionsmultifield;
        if (DS_OPTION_RENDERER.equals(datasource.getResourceType())) {
            ValueMap fieldResourceValueMap = fieldResource.getValueMap();
            String optionsString = (String)fieldResourceValueMap.get(LEGACY_OPTIONS_PROPERTY, String.class);
            if (optionsString != null) {
                return Arrays.stream(optionsString.split("\\,")).map(option -> {
                    option = option.trim();
                    return new EnumerationModelFieldAllOfValues().key((String)option).value((String)option);
                }).collect(Collectors.toUnmodifiableList());
            }
        } else if (DS_OPTION_RENDERER_MULTIFIELD.equals(datasource.getResourceType()) && (optionsmultifield = fieldResource.getChild(LEGACY_OPTIONS_MULTIFIELD)) != null && optionsmultifield.hasChildren()) {
            return StreamSupport.stream(optionsmultifield.getChildren().spliterator(), false).flatMap(enumerationResource -> {
                ValueMap enumerationEntryVM = enumerationResource.getValueMap();
                String key = (String)enumerationEntryVM.get(LEGACY_FIELD_LABEL, String.class);
                String value = (String)enumerationEntryVM.get(LEGACY_FIELD_VALUE, String.class);
                if (key == null || value == null) {
                    return Stream.empty();
                }
                return Stream.of(new EnumerationModelFieldAllOfValues().key(key).value(value));
            }).collect(Collectors.toUnmodifiableList());
        }
        return List.of();
    }

    private void prepareProperties(@NotNull EnumerationModelField field, @NotNull Map<String, Object> properties) {
        properties.putAll(DEFAULT_RESOURCE_PROPERTIES);
        properties.putAll(this.generateMainFieldCommonProperties(field, properties));
        String resourceType = RESOURCE_TYPE_SELECT;
        if (field.getHint() != null && (resourceType = (String)HINT_TO_RESOURCE_TYPE_MAPPING.get((Object)field.getHint())) == null) {
            resourceType = RESOURCE_TYPE_SELECT;
        }
        properties.put("sling:resourceType", resourceType);
        properties.put(LEGACY_FIELD_LABEL, field.getLabel());
        properties.put("valueType", Boolean.TRUE.equals(field.getMultiple()) ? "string[]" : "string");
    }

    @Override
    @NotNull
    public List<String> getResourceTypes() {
        return List.of(RESOURCE_TYPE_SELECT, RESOURCE_TYPE_CHECKBOX, RESOURCE_TYPE_RADIO);
    }

    @Override
    @NotNull
    public List<String> getDataTypes() {
        return List.of(DataType.ENUMERATION.toString());
    }
}

