/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.persistence.legacy;

import com.adobe.cq.dam.cfm.ElementTemplate;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.impl.exceptions.ObjectIntegrityException;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.AbstractFieldManager;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateReader;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateWriter;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.resource.ModelItemsResource;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.adobe.cq.dam.cfm.openapi.models.DataType;
import com.adobe.cq.dam.cfm.openapi.models.DateModelField;
import com.adobe.cq.dam.cfm.openapi.models.DateTimeModelField;
import com.adobe.cq.dam.cfm.openapi.models.TimeModelField;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ElementTemplateReader.class, ElementTemplateWriter.class})
public class DateAndTimeFieldManager
extends AbstractFieldManager<ContentFragmentModelField>
implements ElementTemplateReader {
    private static final Logger log = LoggerFactory.getLogger(DateAndTimeFieldManager.class);
    public static final String LEGACY_VALUE = "value";
    public static final String LEGACY_DISPLAYED_FORMAT = "displayedFormat";
    public static final String LEGACY_EMPTY_TEXT = "emptyText";
    public static final String LEGACY_VALUE_FORMAT = "valueFormat";
    public static final String LEGACY_TYPE = "type";
    public static final String LEGACY_TYPE_DATE = "date";
    public static final String LEGACY_TYPE_TIME = "time";
    public static final String LEGACY_TYPE_DATETIME = "datetime";
    public static final String LEGACY_META_TYPE_VALUE = "date";
    public static final String RESOURCE_TYPE = "dam/cfm/models/editor/components/datatypes/datepicker";
    public static final String DATE_DISPLAYED_FORMAT = "YYYY-MM-DD";
    public static final String TIME_DISPLAYED_FORMAT = "HH:mm";
    public static final String DATETIME_DISPLAYED_FORMAT = "YYYY-MM-DD HH:mm";
    public static final Map<String, Object> DEFAULT_DATE_RESOURCE_PROPERTIES = Map.ofEntries(Map.entry("displayedFormat", "YYYY-MM-DD"), Map.entry("emptyText", new String[]{"YYYY-MM-DD", "YYYY-MM-DD"}), Map.entry("jcr:primaryType", "nt:unstructured"), Map.entry("metaType", "date"), Map.entry("renderReadOnly", Boolean.FALSE.toString()), Map.entry("showEmptyInReadOnly", Boolean.TRUE.toString()), Map.entry("sling:resourceType", "dam/cfm/models/editor/components/datatypes/datepicker"), Map.entry("type", "date"), Map.entry("valueFormat", "YYYY-MM-DD"), Map.entry("valueType", "calendar/date"));
    public static final Map<String, Object> DEFAULT_TIME_RESOURCE_PROPERTIES = Map.ofEntries(Map.entry("displayedFormat", "HH:mm"), Map.entry("emptyText", new String[]{"HH:mm", "HH:mm"}), Map.entry("jcr:primaryType", "nt:unstructured"), Map.entry("metaType", "date"), Map.entry("renderReadOnly", Boolean.FALSE.toString()), Map.entry("showEmptyInReadOnly", Boolean.TRUE.toString()), Map.entry("sling:resourceType", "dam/cfm/models/editor/components/datatypes/datepicker"), Map.entry("type", "time"), Map.entry("valueFormat", "HH:mm"), Map.entry("valueType", "calendar/time"));
    public static final Map<String, Object> DEFAULT_DATETIME_RESOURCE_PROPERTIES = Map.ofEntries(Map.entry("displayedFormat", "YYYY-MM-DD HH:mm"), Map.entry("emptyText", new String[]{"YYYY-MM-DD HH:mm", "YYYY-MM-DD HH:mm"}), Map.entry("jcr:primaryType", "nt:unstructured"), Map.entry("metaType", "date"), Map.entry("renderReadOnly", Boolean.FALSE.toString()), Map.entry("showEmptyInReadOnly", Boolean.TRUE.toString()), Map.entry("sling:resourceType", "dam/cfm/models/editor/components/datatypes/datepicker"), Map.entry("type", "datetime"), Map.entry("valueFormat", "YYYY-MM-DD[T]HH:mm:ss.000Z"), Map.entry("valueType", "calendar/datetime"));

    @Override
    @NotNull
    public Optional<ContentFragmentModelField> convertToDTO(@NotNull ElementTemplate elementTemplate) {
        Resource resource = (Resource)elementTemplate.adaptTo(Resource.class);
        if (resource == null) {
            return Optional.empty();
        }
        String semanticType = elementTemplate.getDataType().getSemanticType();
        if (semanticType == null) {
            return Optional.empty();
        }
        ValueMap valueMap = resource.getValueMap();
        try {
            Calendar defaultValue = (Calendar)valueMap.get(LEGACY_VALUE, Calendar.class);
            OffsetDateTime offsetDateTime = Utils.convertCalendarToOffsetDateTime(defaultValue);
            switch (semanticType) {
                case "date": {
                    return Optional.of(new DateModelField().defaultValue(offsetDateTime == null ? null : offsetDateTime.toLocalDate()).type(DataType.DATE).multiple(elementTemplate.getDataType().isMultiValue()));
                }
                case "datetime": {
                    return Optional.of(new DateTimeModelField().defaultValue(offsetDateTime).type(DataType.DATE_TIME).multiple(elementTemplate.getDataType().isMultiValue()));
                }
                case "time": {
                    return Optional.of(new TimeModelField().defaultValue(offsetDateTime == null ? null : offsetDateTime.toLocalTime()).type(DataType.TIME).multiple(elementTemplate.getDataType().isMultiValue()));
                }
            }
            this.logger.error("Unknown date semantic type {} at {}.", (Object)semanticType, (Object)resource.getPath());
            return Optional.empty();
        }
        catch (IllegalArgumentException ex) {
            log.error("Expected date value {} in properties of resource at path {} is not valid.", valueMap.get((Object)LEGACY_VALUE), (Object)resource.getPath());
            return Optional.empty();
        }
    }

    @Override
    @NotNull
    public Resource generate(@NotNull ModelItemsResource modelItemsResource, @NotNull ContentFragmentModelField field) throws PersistenceException {
        Resource fieldResource = modelItemsResource.getResource(field);
        if (fieldResource == null) {
            fieldResource = modelItemsResource.getResourceResolver().create((Resource)modelItemsResource, field.getName(), this.preparePropertiesInternal(field));
        } else {
            ModifiableValueMap properties = (ModifiableValueMap)fieldResource.adaptTo(ModifiableValueMap.class);
            if (properties != null) {
                this.prepareModifiableValueMapForWriting(properties);
                properties.putAll(this.preparePropertiesInternal(field));
            }
        }
        return fieldResource;
    }

    private Map<String, Object> preparePropertiesInternal(@NotNull ContentFragmentModelField field) {
        HashMap<String, Object> properties = new HashMap<String, Object>(this.generateMainFieldCommonProperties(field, Map.of()));
        DataType dataType = field.getType();
        switch (dataType) {
            case TIME: {
                TimeModelField timeModelField = (TimeModelField)field;
                properties.putAll(DEFAULT_TIME_RESOURCE_PROPERTIES);
                if (timeModelField.getDefaultValue() == null) break;
                LocalTime localTime = timeModelField.getDefaultValue();
                ZoneOffset offset = ZoneOffset.UTC;
                int milliSeconds = (localTime.getHour() * 3600 - offset.getTotalSeconds() + localTime.getMinute() * 60 + localTime.getSecond()) * 1000 + localTime.getNano() / 1000000;
                Calendar date = Calendar.getInstance();
                date.setTimeInMillis(milliSeconds);
                date.setTimeZone(TimeZone.getTimeZone(offset));
                properties.put(LEGACY_VALUE, date);
                break;
            }
            case DATE: {
                properties.putAll(DEFAULT_DATE_RESOURCE_PROPERTIES);
                DateModelField dateModelField = (DateModelField)field;
                if (dateModelField.getDefaultValue() == null) break;
                LocalDate localDate = dateModelField.getDefaultValue();
                Calendar date = Calendar.getInstance();
                date.set(1, localDate.getYear());
                date.set(2, localDate.getMonthValue() - 1);
                date.set(5, localDate.getDayOfMonth());
                date.set(11, 0);
                date.set(12, 0);
                date.set(13, 0);
                date.set(14, 0);
                date.setTimeZone(TimeZone.getTimeZone("GMT"));
                properties.put(LEGACY_VALUE, date);
                break;
            }
            case DATE_TIME: {
                properties.putAll(DEFAULT_DATETIME_RESOURCE_PROPERTIES);
                DateTimeModelField dateTimeModelField = (DateTimeModelField)field;
                if (dateTimeModelField.getDefaultValue() == null) break;
                Calendar calendar = Calendar.getInstance();
                TimeZone timeZone = TimeZone.getTimeZone(dateTimeModelField.getDefaultValue().toZonedDateTime().getZone());
                calendar.setTimeInMillis(dateTimeModelField.getDefaultValue().toInstant().toEpochMilli());
                calendar.setTimeZone(timeZone);
                properties.put(LEGACY_VALUE, calendar);
                break;
            }
            default: {
                throw new ObjectIntegrityException("Invalid data type id: " + dataType + ".", ObjectIntegrityException.Reason.EXTERNAL, null);
            }
        }
        properties.put("fieldLabel", field.getLabel());
        return Map.copyOf(this.removeNullValuesFromProperties(properties));
    }

    @Override
    @NotNull
    public List<String> getResourceTypes() {
        return List.of(RESOURCE_TYPE);
    }

    @Override
    @NotNull
    public List<String> getDataTypes() {
        return List.of(DataType.DATE.toString(), DataType.TIME.toString(), DataType.DATE_TIME.toString());
    }
}

