/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.persistence.legacy;

import com.adobe.cq.dam.cfm.ElementTemplate;
import com.adobe.cq.dam.cfm.FragmentTemplate;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.SchemaConverter;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.TimeAuthorInformation;
import com.adobe.cq.dam.cfm.impl.exceptions.ContentFragmentModelResponseException;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateReader;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.FieldManagerRegistry;
import com.adobe.cq.dam.cfm.impl.servlets.validators.RequestValidator;
import com.adobe.cq.dam.cfm.impl.util.Base64URLHelper;
import com.adobe.cq.dam.cfm.openapi.models.AuthoringInfo;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModel;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.adobe.cq.dam.cfm.openapi.models.Tag;
import com.adobe.cq.dam.cfm.tags.TagsHelper;
import com.day.cq.tagging.TagManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Converter.class})
public class Converter {
    private static final Logger LOG = LoggerFactory.getLogger(Converter.class);
    @Reference
    private FieldManagerRegistry fieldManagerRegistry;
    @Reference
    private RequestValidator requestValidator;

    @NotNull
    public ContentFragmentModel convert(@NotNull FragmentTemplate fragmentTemplate) {
        Resource backingResource = (Resource)fragmentTemplate.adaptTo(Resource.class);
        if (backingResource == null) {
            throw new IllegalStateException("Unable to retrieve resource from fragment template " + fragmentTemplate.getTitle());
        }
        String path = backingResource.getPath();
        Resource modelResource = backingResource;
        if (path.endsWith("/jcr:content") && (modelResource = backingResource.getParent()) == null) {
            throw new IllegalStateException("Unable to retrieve resource from fragment template " + fragmentTemplate.getTitle());
        }
        String name = fragmentTemplate.getTitle();
        String description = fragmentTemplate.getDescription();
        if (description.isEmpty()) {
            description = null;
        }
        boolean isLocked = (Boolean)backingResource.getValueMap().get("isLocked", (Object)false);
        String status = (String)backingResource.getValueMap().get("status", String.class);
        String[] tagIds = (String[])backingResource.getValueMap().get((Object)"cq:tags");
        ArrayList<Tag> tags = new ArrayList();
        TagManager tagManager = (TagManager)backingResource.getResourceResolver().adaptTo(TagManager.class);
        if (tagManager == null) {
            throw new IllegalStateException("Can't acquire TagManager from resource (null)");
        }
        if (tagIds != null) {
            tags = this.getTags(tagManager, tagIds);
        }
        ArrayList<ContentFragmentModelField> fields = new ArrayList<ContentFragmentModelField>();
        Iterator elementsIterator = fragmentTemplate.getElements();
        while (elementsIterator.hasNext()) {
            ElementTemplate element = (ElementTemplate)elementsIterator.next();
            Optional<ContentFragmentModelField> optionalField = this.readField(element);
            if (optionalField.isEmpty()) {
                LOG.error("Received unsupported field {} for Content Fragment Model with name {}", (Object)element.getName(), (Object)name);
                continue;
            }
            fields.add(optionalField.get());
        }
        ContentFragmentModel.StatusEnum statusEnum = null;
        try {
            statusEnum = StringUtils.isBlank((CharSequence)status) ? ContentFragmentModel.StatusEnum.ENABLED : ContentFragmentModel.StatusEnum.fromValue(status);
        }
        catch (IllegalArgumentException e) {
            throw new ContentFragmentModelResponseException("Cannot convert status " + status + " to a supported status type");
        }
        return new ContentFragmentModel().id(Base64URLHelper.toId(modelResource.getPath())).path(modelResource.getPath()).name(name).description(description).created(SchemaConverter.convert(TimeAuthorInformation.created(backingResource.getValueMap()), AuthoringInfo.class)).modified(SchemaConverter.convert(TimeAuthorInformation.modified(backingResource.getValueMap()), AuthoringInfo.class)).published(SchemaConverter.convert(TimeAuthorInformation.published(backingResource.getValueMap()), AuthoringInfo.class)).locked(isLocked).status(statusEnum).tags(tags).fields(fields);
    }

    private List<Tag> getTags(TagManager tagManager, String[] tagIds) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (String tag : tagIds) {
            com.day.cq.tagging.Tag currentTag = tagManager.resolve(tag);
            if (currentTag == null) continue;
            tags.add(new Tag().id(currentTag.getTagID()).title(currentTag.getTitle()).titlePath(currentTag.getTitlePath()).path(currentTag.getPath()).name(currentTag.getName()).i18n(TagsHelper.getTagI18nList(currentTag)).description(currentTag.getDescription()));
        }
        return tags;
    }

    public Optional<ContentFragmentModelField> readField(@NotNull ElementTemplate elementTemplate) {
        ElementTemplateReader elementTemplateReader = this.fieldManagerRegistry.getReader(elementTemplate);
        if (elementTemplateReader == null) {
            return Optional.empty();
        }
        Optional<ContentFragmentModelField> optionalField = elementTemplateReader.convertToDTO(elementTemplate);
        if (optionalField.isEmpty()) {
            return Optional.empty();
        }
        ContentFragmentModelField contentFragmentModelField = optionalField.get();
        contentFragmentModelField.name(elementTemplate.getName()).label(elementTemplate.getTitle());
        Resource fieldResource = (Resource)elementTemplate.adaptTo(Resource.class);
        if (fieldResource != null) {
            contentFragmentModelField.description((String)fieldResource.getValueMap().get("fieldDescription", String.class)).required("on".equalsIgnoreCase((String)fieldResource.getValueMap().get("required", String.class)));
            Resource graniteData = fieldResource.getChild("granite:data");
            if (graniteData != null) {
                ValueMap graniteDataValueMap = graniteData.getValueMap();
                if (graniteDataValueMap.containsKey((Object)"mvmaxitems")) {
                    contentFragmentModelField.setMaxItems((Integer)graniteDataValueMap.get("mvmaxitems", Integer.class));
                }
                if (graniteDataValueMap.containsKey((Object)"mvminitems")) {
                    contentFragmentModelField.setMinItems((Integer)graniteDataValueMap.get("mvminitems", Integer.class));
                }
            }
        }
        return Optional.of(contentFragmentModelField);
    }

    @NotNull
    public List<ContentFragmentModel> convert(@NotNull List<Resource> resources) {
        return resources.stream().map(resource -> (FragmentTemplate)resource.adaptTo(FragmentTemplate.class)).filter(Objects::nonNull).map(this::convert).collect(Collectors.toList());
    }
}

