/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.persistence.legacy;

import com.adobe.cq.dam.cfm.ElementTemplate;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.AbstractFieldManager;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateReader;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateWriter;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.adobe.cq.dam.cfm.openapi.models.ContentReferenceModelField;
import com.adobe.cq.dam.cfm.openapi.models.ContentType;
import com.adobe.cq.dam.cfm.openapi.models.DataType;
import com.adobe.cq.dam.cfm.openapi.models.FileSize;
import com.adobe.cq.dam.cfm.openapi.models.MinMax;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={ElementTemplateReader.class, ElementTemplateWriter.class})
public class ContentReferenceFieldManager
extends AbstractFieldManager<ContentReferenceModelField>
implements ElementTemplateReader {
    public static final String RESOURCE_TYPE = "dam/cfm/models/editor/components/contentreference";
    public static final String MULTI_RESOURCE_TYPE = "granite/ui/components/coral/foundation/form/multifield";
    public static final String LEGACY_CONTENT_TYPES_PROPERTY = "validation";
    public static final String LEGACY_FILESIZE_MIN = "filesize-min";
    public static final String LEGACY_FILESIZE_MIN_UNIT = "filesize-minunit";
    public static final String LEGACY_FILESIZE_MAX = "filesize-max";
    public static final String LEGACY_FILESIZE_MAX_UNIT = "filesize-maxunit";
    public static final String LEGACY_IMAGE_WIDTH_MAX = "imagewidth-max";
    public static final String LEGACY_IMAGE_WIDTH_MIN = "imagewidth-min";
    public static final String LEGACY_IMAGE_HEIGHT_MAX = "imageheight-max";
    public static final String LEGACY_IMAGE_HEIGHT_MIN = "imageheight-min";
    public static final String LEGACY_ROOT_PATH = "rootPath";
    public static final String LEGACY_VALUE = "value";
    public static final String LEGACY_CONTENT_TYPE_PREFIX = "cfm.validation.contenttype.";
    public static final String LEGACY_FILTER = "filter";
    public static final String LEGACY_SHOW_THUMBNAIL = "showThumbnail";
    public static final String LEGACY_FILESIZE_VALIDATION = "filesize-validation";
    public static final String LEGACY_FILESIZE_VALIDATION_MIN = "cfm.validation.filesize.min";
    public static final String LEGACY_FILESIZE_VALIDATION_MAX = "cfm.validation.filesize.max";
    public static final String LEGACY_FILESIZE_VALIDATION_INTERVAL = "cfm.validation.filesize.interval";
    public static final String LEGACY_IMAGE_HEIGHT_VALIDATION = "imageheight-validation";
    public static final String LEGACY_IMAGE_HEIGHT_VALIDATION_MIN = "cfm.validation.imageheight.min";
    public static final String LEGACY_IMAGE_HEIGHT_VALIDATION_MAX = "cfm.validation.imageheight.max";
    public static final String LEGACY_IMAGE_HEIGHT_VALIDATION_INTERVAL = "cfm.validation.imageheight.interval";
    public static final String LEGACY_IMAGE_WIDTH_VALIDATION = "imagewidth-validation";
    public static final String LEGACY_IMAGE_WIDTH_VALIDATION_MIN = "cfm.validation.imagewidth.min";
    public static final String LEGACY_IMAGE_WIDTH_VALIDATION_MAX = "cfm.validation.imagewidth.max";
    public static final String LEGACY_IMAGE_WIDTH_VALIDATION_INTERVAL = "cfm.validation.imagewidth.interval";
    public static final Map<String, Object> DEFAULT_RESOURCE_PROPERTIES = Map.of("jcr:primaryType", "nt:unstructured", "sling:resourceType", "dam/cfm/models/editor/components/contentreference", "filter", "hierarchy", "metaType", "reference", "renderReadOnly", "false", "showEmptyInReadOnly", "true", "showThumbnail", "false", "valueType", "string/reference");
    private static final Set<String> GRANITE_DATA_PROPERTIES = Set.of("filesize-min", "filesize-minunit", "filesize-max", "filesize-maxunit", "imagewidth-max", "imagewidth-min", "imageheight-max", "imageheight-min", "mvmaxitems", "mvminitems");

    @Override
    @NotNull
    public List<String> getResourceTypes() {
        return List.of(RESOURCE_TYPE);
    }

    @Override
    @NotNull
    public List<String> getDataTypes() {
        return List.of(DataType.CONTENT_REFERENCE.toString());
    }

    @Override
    @NotNull
    public Optional<ContentFragmentModelField> convertToDTO(@NotNull ElementTemplate elementTemplate) {
        ContentReferenceModelField modelField = new ContentReferenceModelField();
        Resource resource = (Resource)elementTemplate.adaptTo(Resource.class);
        if (resource == null) {
            return Optional.empty();
        }
        ValueMapDecorator legacyMap = new ValueMapDecorator(new HashMap(resource.getValueMap()));
        Resource graniteData = resource.getChild("granite:data");
        if (graniteData != null) {
            for (Map.Entry graniteDataEntry : graniteData.getValueMap().entrySet()) {
                legacyMap.putIfAbsent((Object)((String)graniteDataEntry.getKey()), graniteDataEntry.getValue());
            }
        }
        String[] allowedContentTypes = (String[])legacyMap.get(LEGACY_CONTENT_TYPES_PROPERTY, String[].class);
        modelField.setRoot((String)legacyMap.get(LEGACY_ROOT_PATH, String.class));
        modelField.setDefaultValue((String)legacyMap.get(LEGACY_VALUE, String.class));
        Integer min = (Integer)legacyMap.get(LEGACY_IMAGE_WIDTH_MIN, Integer.class);
        Integer max = (Integer)legacyMap.get(LEGACY_IMAGE_WIDTH_MAX, Integer.class);
        if (min != null || max != null) {
            modelField.setImageWidth(new MinMax().min(min).max(max));
        }
        min = (Integer)legacyMap.get(LEGACY_IMAGE_HEIGHT_MIN, Integer.class);
        max = (Integer)legacyMap.get(LEGACY_IMAGE_HEIGHT_MAX, Integer.class);
        if (min != null || max != null) {
            modelField.setImageHeight(new MinMax().min(min).max(max));
        }
        Integer fileSizeMin = (Integer)legacyMap.get(LEGACY_FILESIZE_MIN, Integer.class);
        String fileSizeMinUnit = (String)legacyMap.get(LEGACY_FILESIZE_MIN_UNIT, String.class);
        if (fileSizeMin != null && fileSizeMinUnit != null) {
            modelField.setFileSizeMin(new FileSize().unit(FileSize.UnitEnum.fromValue(fileSizeMinUnit)).size(fileSizeMin));
        }
        Integer fileSizeMax = (Integer)legacyMap.get(LEGACY_FILESIZE_MAX, Integer.class);
        String fileSizeMaxUnit = (String)legacyMap.get(LEGACY_FILESIZE_MAX_UNIT, String.class);
        if (fileSizeMax != null && fileSizeMaxUnit != null) {
            modelField.setFileSizeMax(new FileSize().unit(FileSize.UnitEnum.fromValue(fileSizeMaxUnit)).size(fileSizeMax));
        }
        modelField.setAllowedContentTypes(allowedContentTypes == null ? null : this.getAllowedContentTypes(allowedContentTypes));
        modelField.setMultiple(elementTemplate.getDataType().isMultiValue());
        return Optional.of(modelField.type(DataType.CONTENT_REFERENCE));
    }

    @Override
    @NotNull
    protected Optional<String> getMultiFieldResourceType() {
        return Optional.of(MULTI_RESOURCE_TYPE);
    }

    @Override
    @NotNull
    protected Pair<Map<String, Object>, Map<String, Object>> generateFieldResourceProperties(@NotNull ContentReferenceModelField field) {
        Map<String, Object> main = this.generateMainFieldCommonProperties(field, DEFAULT_RESOURCE_PROPERTIES);
        if (field.getFileSizeMin() != null) {
            main.put(LEGACY_FILESIZE_MIN_UNIT, this.processValue((Object)field.getFileSizeMin().getUnit()));
            main.put(LEGACY_FILESIZE_MIN, this.processValue(field.getFileSizeMin().getSize()));
        }
        if (field.getFileSizeMax() != null) {
            main.put(LEGACY_FILESIZE_MAX_UNIT, this.processValue((Object)field.getFileSizeMax().getUnit()));
            main.put(LEGACY_FILESIZE_MAX, this.processValue(field.getFileSizeMax().getSize()));
        }
        if (field.getImageWidth() != null) {
            main.put(LEGACY_IMAGE_WIDTH_MIN, this.processValue(field.getImageWidth().getMin()));
            main.put(LEGACY_IMAGE_WIDTH_MAX, this.processValue(field.getImageWidth().getMax()));
        }
        if (field.getImageHeight() != null) {
            main.put(LEGACY_IMAGE_HEIGHT_MIN, this.processValue(field.getImageHeight().getMin()));
            main.put(LEGACY_IMAGE_HEIGHT_MAX, this.processValue(field.getImageHeight().getMax()));
        }
        main.put("fieldLabel", field.getLabel());
        main.put(LEGACY_ROOT_PATH, this.processValue(field.getRoot()));
        main.put(LEGACY_VALUE, this.processValue(field.getDefaultValue()));
        if (field.getAllowedContentTypes() != null) {
            main.put(LEGACY_CONTENT_TYPES_PROPERTY, this.processValue(this.transformNewToLegacyContentTypes(field.getAllowedContentTypes())));
        }
        if (Boolean.TRUE.equals(field.getMultiple())) {
            main.put("valueType", "string/reference[]");
        } else {
            main.put("valueType", "string/reference");
        }
        main = this.removeNullValuesFromProperties(main);
        HashMap<String, Object> graniteDataProperties = new HashMap<String, Object>(DEFAULT_GRANITE_DATA_RESOURCE_PROPERTIES);
        graniteDataProperties.putAll(main.entrySet().stream().filter(entry -> GRANITE_DATA_PROPERTIES.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        for (String key : GRANITE_DATA_PROPERTIES) {
            main.remove(key);
        }
        if (graniteDataProperties.containsKey(LEGACY_FILESIZE_MIN) && graniteDataProperties.containsKey(LEGACY_FILESIZE_MAX)) {
            graniteDataProperties.put(LEGACY_FILESIZE_VALIDATION, LEGACY_FILESIZE_VALIDATION_INTERVAL);
        } else if (graniteDataProperties.containsKey(LEGACY_FILESIZE_MIN)) {
            graniteDataProperties.put(LEGACY_FILESIZE_VALIDATION, LEGACY_FILESIZE_VALIDATION_MIN);
        } else if (graniteDataProperties.containsKey(LEGACY_FILESIZE_MAX)) {
            graniteDataProperties.put(LEGACY_FILESIZE_VALIDATION, LEGACY_FILESIZE_VALIDATION_MAX);
        }
        if (graniteDataProperties.containsKey(LEGACY_IMAGE_WIDTH_MIN) && graniteDataProperties.containsKey(LEGACY_IMAGE_WIDTH_MAX)) {
            graniteDataProperties.put(LEGACY_IMAGE_WIDTH_VALIDATION, LEGACY_IMAGE_WIDTH_VALIDATION_INTERVAL);
        } else if (graniteDataProperties.containsKey(LEGACY_IMAGE_WIDTH_MIN)) {
            graniteDataProperties.put(LEGACY_IMAGE_WIDTH_VALIDATION, LEGACY_IMAGE_WIDTH_VALIDATION_MIN);
        } else if (graniteDataProperties.containsKey(LEGACY_IMAGE_WIDTH_MAX)) {
            graniteDataProperties.put(LEGACY_IMAGE_WIDTH_VALIDATION, LEGACY_IMAGE_WIDTH_VALIDATION_MAX);
        }
        if (graniteDataProperties.containsKey(LEGACY_IMAGE_HEIGHT_MIN) && graniteDataProperties.containsKey(LEGACY_IMAGE_HEIGHT_MAX)) {
            graniteDataProperties.put(LEGACY_IMAGE_HEIGHT_VALIDATION, LEGACY_IMAGE_HEIGHT_VALIDATION_INTERVAL);
        } else if (graniteDataProperties.containsKey(LEGACY_IMAGE_HEIGHT_MIN)) {
            graniteDataProperties.put(LEGACY_IMAGE_HEIGHT_VALIDATION, LEGACY_IMAGE_HEIGHT_VALIDATION_MIN);
        } else if (graniteDataProperties.containsKey(LEGACY_IMAGE_HEIGHT_MAX)) {
            graniteDataProperties.put(LEGACY_IMAGE_HEIGHT_VALIDATION, LEGACY_IMAGE_HEIGHT_VALIDATION_MAX);
        }
        return Pair.of(this.removeNullValuesFromProperties(main), this.removeNullValuesFromProperties(graniteDataProperties));
    }

    @Override
    @NotNull
    protected Map<String, Object> generateFieldSubResourceProperties(@NotNull ContentReferenceModelField field) {
        if (Boolean.TRUE.equals(field.getMultiple())) {
            Map<String, Object> properties = this.generateFieldResourceCommonProperties(field, new HashMap<String, Object>(DEFAULT_FIELD_SUB_RESOURCE_PROPERTIES));
            properties.put("emptyText", field.getPlaceholder());
            properties.put(LEGACY_VALUE, field.getDefaultValue());
            properties.put(LEGACY_SHOW_THUMBNAIL, field.getShowThumbnail());
            properties.put(LEGACY_ROOT_PATH, field.getRoot());
            if (field.getAllowedContentTypes() != null) {
                properties.put(LEGACY_CONTENT_TYPES_PROPERTY, this.processValue(this.transformNewToLegacyContentTypes(field.getAllowedContentTypes())));
            }
            return Map.copyOf(this.removeNullValuesFromProperties(properties));
        }
        return Map.of();
    }

    @NotNull
    private List<ContentType> getAllowedContentTypes(@NotNull String[] legacyAllowedContentTypes) {
        return Arrays.stream(legacyAllowedContentTypes).map(legacyAllowedContentType -> ContentType.fromValue(legacyAllowedContentType.substring(LEGACY_CONTENT_TYPE_PREFIX.length()))).collect(Collectors.toUnmodifiableList());
    }

    @NotNull
    private String[] transformNewToLegacyContentTypes(@NotNull List<ContentType> contentTypes) {
        return (String[])contentTypes.stream().map(contentType -> LEGACY_CONTENT_TYPE_PREFIX + contentType.toString()).toArray(String[]::new);
    }
}

