/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.persistence.legacy;

import com.adobe.cq.dam.cfm.ElementTemplate;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.AbstractFieldManager;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateReader;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateWriter;
import com.adobe.cq.dam.cfm.openapi.models.BooleanModelField;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.adobe.cq.dam.cfm.openapi.models.DataType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={ElementTemplateReader.class, ElementTemplateWriter.class})
public class BooleanFieldManager
extends AbstractFieldManager<BooleanModelField>
implements ElementTemplateReader {
    public static final String LEGACY_CHECKED = "checked";
    public static final String RESOURCE_TYPE = "granite/ui/components/coral/foundation/form/checkbox";
    private static final Map<String, Object> DEFAULT_RESOURCE_PROPERTIES = Map.of("jcr:primaryType", "nt:unstructured", "sling:resourceType", "granite/ui/components/coral/foundation/form/checkbox", "metaType", "boolean", "renderReadOnly", "false", "showEmptyInReadOnly", "true", "valueType", "boolean");

    @Override
    @NotNull
    public Optional<ContentFragmentModelField> convertToDTO(@NotNull ElementTemplate elementTemplate) {
        Resource resource = (Resource)elementTemplate.adaptTo(Resource.class);
        if (resource == null) {
            return Optional.empty();
        }
        BooleanModelField modelField = new BooleanModelField();
        Boolean defaultValue = (Boolean)resource.getValueMap().get(LEGACY_CHECKED, Boolean.class);
        modelField.setDefaultValue(defaultValue);
        modelField.setMultiple(elementTemplate.getDataType().isMultiValue());
        return Optional.of(modelField.type(DataType.BOOLEAN));
    }

    @Override
    @NotNull
    protected Pair<Map<String, Object>, Map<String, Object>> generateFieldResourceProperties(@NotNull BooleanModelField field) {
        Map<String, Object> mainFieldProperties = this.generateMainFieldCommonProperties(field, new HashMap<String, Object>(DEFAULT_RESOURCE_PROPERTIES));
        mainFieldProperties.put(LEGACY_CHECKED, this.processValue(field.getDefaultValue()));
        mainFieldProperties.put("text", field.getLabel());
        return Pair.of(mainFieldProperties, Map.of());
    }

    @Override
    @NotNull
    public List<String> getResourceTypes() {
        return List.of(RESOURCE_TYPE);
    }

    @Override
    @NotNull
    public List<String> getDataTypes() {
        return List.of(DataType.BOOLEAN.toString());
    }
}

