/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.persistence.legacy;

import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateWriter;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.resource.ModelItemsResource;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFieldManager<T extends ContentFragmentModelField>
implements ElementTemplateWriter<T> {
    public static final String LEGACY_MAX_ITEMS = "mvmaxitems";
    public static final String LEGACY_MIN_ITEMS = "mvminitems";
    public static final Map<String, Object> DEFAULT_GRANITE_DATA_RESOURCE_PROPERTIES = Map.of("jcr:primaryType", "nt:unstructured");
    public static final Map<String, Object> DEFAULT_FIELD_SUB_RESOURCE_PROPERTIES = Map.of("jcr:primaryType", "nt:unstructured");
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @NotNull
    protected Map<String, Object> generateMainFieldCommonProperties(@NotNull ContentFragmentModelField field, @NotNull Map<String, Object> properties) {
        HashMap<String, Object> result = new HashMap<String, Object>(properties);
        result.put("name", field.getName());
        if (Boolean.TRUE.equals(field.getRequired())) {
            result.put("required", "on");
        }
        if (field.getDescription() != null) {
            result.put("fieldDescription", field.getDescription());
        }
        return this.removeNullValuesFromProperties(result);
    }

    @NotNull
    protected Map<String, Object> generateFieldResourceCommonProperties(@NotNull ContentFragmentModelField field, @NotNull Map<String, Object> properties) {
        HashMap<String, Object> result = new HashMap<String, Object>(properties);
        result.put("name", field.getName());
        return this.removeNullValuesFromProperties(result);
    }

    protected Map<String, Object> removeNullValuesFromProperties(@NotNull Map<String, Object> properties) {
        HashMap<String, Object> result = new HashMap<String, Object>(properties);
        result.values().removeIf(Objects::isNull);
        return result;
    }

    protected void prepareModifiableValueMapForWriting(@NotNull ModifiableValueMap modifiableValueMap) {
        for (String key : new HashSet(modifiableValueMap.keySet())) {
            try {
                modifiableValueMap.remove((Object)key);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Override
    @NotNull
    public Resource generate(@NotNull ModelItemsResource modelItemsResource, @NotNull T field) throws PersistenceException {
        Resource fieldResource = modelItemsResource.getResource((ContentFragmentModelField)field);
        Pair<Map<String, Object>, Map<String, Object>> propertiesPair = this.generateFieldResourceProperties(field);
        Map<String, Object> fieldResourceProperties = this.generateFieldSubResourceProperties(field);
        Map<String, Object> mainFieldProperties = this.generateMainFieldCommonProperties((ContentFragmentModelField)field, (Map)propertiesPair.getLeft());
        HashMap<String, Object> graniteDataProperties = new HashMap<String, Object>((Map)propertiesPair.getRight());
        Map<String, Object> fieldSubResourcePropertiesMap = this.generateFieldResourceCommonProperties((ContentFragmentModelField)field, fieldResourceProperties);
        if (((ContentFragmentModelField)field).getMinItems() != null) {
            graniteDataProperties.put(LEGACY_MIN_ITEMS, ((ContentFragmentModelField)field).getMinItems().toString());
        }
        if (((ContentFragmentModelField)field).getMaxItems() != null) {
            graniteDataProperties.put(LEGACY_MAX_ITEMS, ((ContentFragmentModelField)field).getMaxItems().toString());
        }
        String resourceType = mainFieldProperties.get("sling:resourceType").toString();
        if (fieldResource == null) {
            if (Boolean.TRUE.equals(((ContentFragmentModelField)field).getMultiple())) {
                mainFieldProperties.put("sling:resourceType", this.getMultiFieldResourceType().orElseThrow());
            }
            fieldResource = modelItemsResource.getResourceResolver().create((Resource)modelItemsResource, ((ContentFragmentModelField)field).getName(), mainFieldProperties);
            modelItemsResource.getResourceResolver().create(fieldResource, "granite:data", graniteDataProperties);
            if (Boolean.TRUE.equals(((ContentFragmentModelField)field).getMultiple())) {
                fieldSubResourcePropertiesMap.put("sling:resourceType", resourceType);
                Resource fieldSubResource = modelItemsResource.getResourceResolver().create(fieldResource, "field", fieldSubResourcePropertiesMap);
                modelItemsResource.getResourceResolver().create(fieldSubResource, "granite:data", graniteDataProperties);
            }
        } else {
            ModifiableValueMap properties = (ModifiableValueMap)fieldResource.adaptTo(ModifiableValueMap.class);
            if (properties != null) {
                this.prepareModifiableValueMapForWriting(properties);
                properties.putAll(mainFieldProperties);
                Resource graniteDataResource = fieldResource.getChild("granite:data");
                if (graniteDataResource == null) {
                    modelItemsResource.getResourceResolver().create(fieldResource, "granite:data", graniteDataProperties);
                } else {
                    this.updateGraniteData(graniteDataResource, graniteDataProperties);
                }
                if (Boolean.TRUE.equals(((ContentFragmentModelField)field).getMultiple())) {
                    properties.put((Object)"sling:resourceType", (Object)this.getMultiFieldResourceType().orElseThrow());
                    Resource fieldSubResource = fieldResource.getChild("field");
                    if (fieldSubResource != null && resourceType.equals(fieldSubResource.getResourceType())) {
                        ModifiableValueMap fieldSubResourceProperties = (ModifiableValueMap)fieldSubResource.adaptTo(ModifiableValueMap.class);
                        if (fieldSubResourceProperties != null) {
                            fieldSubResourceProperties.put((Object)"sling:resourceType", (Object)resourceType);
                        }
                    } else if (fieldSubResource == null) {
                        fieldSubResourcePropertiesMap.put("sling:resourceType", resourceType);
                        fieldSubResource = modelItemsResource.getResourceResolver().create(fieldResource, "field", fieldSubResourcePropertiesMap);
                        Resource fieldGraniteData = fieldSubResource.getChild("granite:data");
                        if (fieldGraniteData == null) {
                            modelItemsResource.getResourceResolver().create(fieldSubResource, "granite:data", graniteDataProperties);
                        } else {
                            this.updateGraniteData(fieldGraniteData, graniteDataProperties);
                        }
                    }
                } else {
                    Resource fieldSubResource = fieldResource.getChild("field");
                    if (fieldSubResource != null) {
                        modelItemsResource.getResourceResolver().delete(fieldSubResource);
                    }
                }
            }
        }
        return fieldResource;
    }

    @NotNull
    protected Pair<Map<String, Object>, Map<String, Object>> generateFieldResourceProperties(@NotNull T field) {
        return Pair.of(Map.of(), Map.of());
    }

    @NotNull
    protected Map<String, Object> generateFieldSubResourceProperties(@NotNull T field) {
        return Map.of();
    }

    protected Object processValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return value;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof String[]) {
            return value;
        }
        if (value instanceof Collection) {
            Collection originalCollection = (Collection)value;
            Iterator iterator = originalCollection.iterator();
            String[] collectionResult = new String[originalCollection.size()];
            int index = 0;
            while (iterator.hasNext()) {
                collectionResult[index++] = String.valueOf(iterator.next());
            }
            return collectionResult;
        }
        return String.valueOf(value);
    }

    @NotNull
    protected Optional<String> getMultiFieldResourceType() {
        return Optional.empty();
    }

    protected void updateGraniteData(Resource graniteDataResource, Map<String, Object> graniteDataProperties) {
        ModifiableValueMap graniteDataPropertiesVM = (ModifiableValueMap)graniteDataResource.adaptTo(ModifiableValueMap.class);
        if (graniteDataPropertiesVM != null) {
            this.prepareModifiableValueMapForWriting(graniteDataPropertiesVM);
            graniteDataPropertiesVM.putAll(graniteDataProperties);
        }
    }
}

