/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.persistence;

import com.adobe.cq.dam.cfm.impl.exceptions.ObjectIntegrityException;
import com.adobe.cq.dam.cfm.impl.exceptions.UnauthorizedActionException;
import com.adobe.cq.dam.cfm.impl.persistence.PersistableContentFragmentModel;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.Converter;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.ElementTemplateWriter;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.FieldManagerRegistry;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.resource.ModelItemsResource;
import com.adobe.cq.dam.cfm.impl.util.Base64URLHelper;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModel;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.adobe.cq.dam.cfm.openapi.models.CreateContentFragmentModel;
import com.adobe.cq.dam.cfm.openapi.models.DataType;
import com.adobe.cq.dam.cfm.openapi.models.FragmentReferenceModelField;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.TemplateManager;
import com.day.cq.wcm.api.WCMException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ContentFragmentModelManager.class})
public class ContentFragmentModelManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentFragmentModelManager.class);
    public static final String CONF_FOLDER = "/conf";
    public static final String NN_DAM_CFM = "dam/cfm";
    public static final String NN_MODELS = "models";
    public static final String NN_METADATA = "metadata";
    public static final String NN_ITEMS = "jcr:content/model/cq:dialog/content/items";
    private static final String JCR_CONTENT = "jcr:content";
    public static final String PN_STATUS = "status";
    public static final String CONF_DAM_CFM = "dam/cfm";
    public static final String CONF_MODELS = "dam/cfm/models";
    public static final String CONF_SETTINGS_PATH = "/conf/global/settings";
    public static final String DEFAULT_MODELS_PARENT = "/conf/global/settings/dam/cfm/models";
    public static final String DEFAULT_MODEL_TYPE = "/libs/settings/dam/cfm/model-types/fragment";
    public static final int LIST_MODELS_LIMIT = 50;
    private static final List<String> CONF_BUCKET_NAMES = List.of("settings", "sling:configs");
    private static final String ERROR_MESSAGE_MODEL_NAME = "Unable to create a resource for model %s.";
    private static final String ERROR_MESSAGE_MODELS = "Unable to create one or more models: model %s is referencing a non-existent model %s.";
    private static final String ERROR_MESSAGE_MODELS_CYCLE = "Unable to create one or more models: detected a reference cycle for %s";
    @Reference
    private ConfigurationResourceResolver configurationResolver;
    @Reference
    private FieldManagerRegistry fieldManagerRegistry;
    @Reference
    private Converter converter;

    @NotNull
    public ContentFragmentModel createModel(@NotNull ResourceResolver resourceResolver, @NotNull CreateContentFragmentModel request, boolean shouldCommit) throws PersistenceException, WCMException {
        try {
            ContentFragmentModel contentFragmentModel;
            Resource modelResource = this.createContentFragmentModelResource(resourceResolver, request.getName(), request.getStatus(), request.getDescription(), request.getConfigurationFolder());
            this.generateFields(request, modelResource);
            if (shouldCommit) {
                resourceResolver.commit();
            }
            if ((contentFragmentModel = (ContentFragmentModel)modelResource.adaptTo(ContentFragmentModel.class)) != null) {
                return contentFragmentModel;
            }
        }
        catch (Exception e) {
            if (e instanceof PersistenceException || e instanceof WCMException) {
                throw e;
            }
            throw new IllegalStateException("Unable to create a resource for your request.", e);
        }
        throw new PersistenceException(String.format(ERROR_MESSAGE_MODEL_NAME, request.getName()));
    }

    @NotNull
    public List<ContentFragmentModel> createModels(@NotNull ResourceResolver resourceResolver, @NotNull List<CreateContentFragmentModel> contentFragmentModels, boolean shouldCommit) throws PersistenceException, WCMException {
        List<ContentFragmentModel> createdModels = new ArrayList<ContentFragmentModel>();
        Pair<List<CreateContentFragmentModel>, List<CreateContentFragmentModel>> modelsWithAndWithoutReferences = this.splitModels(contentFragmentModels);
        List modelsWithoutReferences = (List)modelsWithAndWithoutReferences.getLeft();
        List modelsWithReferences = (List)modelsWithAndWithoutReferences.getRight();
        if (modelsWithReferences.isEmpty()) {
            for (CreateContentFragmentModel modelWithoutReferences : modelsWithoutReferences) {
                createdModels.add(this.createModel(resourceResolver, modelWithoutReferences, false));
            }
        } else {
            Map<String, Set<String>> dependencyMap = this.getDependencyMap(modelsWithoutReferences, modelsWithReferences);
            this.checkDependencies(resourceResolver, dependencyMap);
            Set<String> orderOfCFMs = this.getCreationOrder(dependencyMap);
            HashMap<String, CreateContentFragmentModel> contentFragmentModelsMap = new HashMap<String, CreateContentFragmentModel>();
            for (CreateContentFragmentModel cfm : contentFragmentModels) {
                contentFragmentModelsMap.put(this.getPath(cfm.getConfigurationFolder(), cfm.getName()), cfm);
            }
            createdModels = this.createModelsWithReferences(resourceResolver, orderOfCFMs, contentFragmentModelsMap);
        }
        if (shouldCommit) {
            resourceResolver.commit();
        }
        return createdModels;
    }

    @NotNull
    public List<ContentFragmentModel> getModels(@NotNull ResourceResolver resourceResolver, int limit, @Nullable String after) {
        if (limit <= 0 || limit > 50) {
            limit = 50;
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(CONF_FOLDER);
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM [cq:Template] AS p WHERE ISDESCENDANTNODE(p,'%s') ");
        query.append("AND p.[jcr:path] LIKE '/conf/%%%%/settings/dam/cfm/models/%%%%' ");
        if (StringUtils.isNotEmpty((CharSequence)after)) {
            query.append("AND p.[jcr:path] > '%s' ");
            arguments.add(after);
        }
        query.append("ORDER BY [jcr:path] ");
        query.append("OPTION (INDEX TAG[fragments], LIMIT %s)");
        arguments.add(String.valueOf(limit));
        ArrayList<Resource> modelsResources = new ArrayList<Resource>();
        resourceResolver.findResources(String.format(query.toString(), arguments.toArray(new String[0])), "JCR-SQL2").forEachRemaining(modelsResources::add);
        return this.converter.convert(modelsResources);
    }

    @Nullable
    public ContentFragmentModel getModel(@NotNull ResourceResolver resourceResolver, @NotNull String id) {
        Resource resource = this.getContentFragmentResource(resourceResolver, id);
        if (resource == null) {
            return null;
        }
        return (ContentFragmentModel)resource.adaptTo(ContentFragmentModel.class);
    }

    @NotNull
    public ContentFragmentModel updateModel(@NotNull PersistableContentFragmentModel persistableContentFragmentModel) throws PersistenceException {
        ContentFragmentModel persistedModel;
        Resource items;
        if (!persistableContentFragmentModel.hasChanges()) {
            return persistableContentFragmentModel.getBase();
        }
        Resource jcrContent = persistableContentFragmentModel.getResource().getChild(JCR_CONTENT);
        if (jcrContent == null) {
            throw new ObjectIntegrityException(String.format("Content Fragment Model %s is missing its content resource.", persistableContentFragmentModel.getBase().getId()), ObjectIntegrityException.Reason.INTERNAL, null);
        }
        ModifiableValueMap properties = (ModifiableValueMap)jcrContent.adaptTo(ModifiableValueMap.class);
        if (properties == null) {
            throw new UnauthorizedActionException(String.format("Content Fragment Model %s cannot be edited by this user.", persistableContentFragmentModel.getBase().getId()));
        }
        properties.put((Object)"jcr:title", (Object)persistableContentFragmentModel.getChanges().getName());
        properties.put((Object)PN_STATUS, (Object)persistableContentFragmentModel.getChanges().getStatus().toString());
        if (persistableContentFragmentModel.getChanges().getDescription() != null) {
            properties.put((Object)"jcr:description", (Object)persistableContentFragmentModel.getChanges().getDescription());
        }
        if ((items = persistableContentFragmentModel.getResource().getChild(NN_ITEMS)) == null) {
            throw new ObjectIntegrityException(String.format("Content Fragment Model %s is missing its %s resource.", persistableContentFragmentModel.getBase().getId(), NN_ITEMS), ObjectIntegrityException.Reason.INTERNAL, null);
        }
        ModelItemsResource modelItemsResource = new ModelItemsResource(items);
        LinkedHashSet<ContentFragmentModelField> removedFields = new LinkedHashSet<ContentFragmentModelField>(persistableContentFragmentModel.getBase().getFields());
        removedFields.removeAll(persistableContentFragmentModel.getChanges().getFields());
        for (ContentFragmentModelField removedField : removedFields) {
            modelItemsResource.deleteField(removedField.getName());
        }
        for (ContentFragmentModelField field : persistableContentFragmentModel.getChanges().getFields()) {
            modelItemsResource.deleteField(field.getName());
            ElementTemplateWriter<ContentFragmentModelField> fieldWriter = this.fieldManagerRegistry.getWriter(field.getType());
            if (fieldWriter == null) continue;
            fieldWriter.generate(modelItemsResource, field);
        }
        ResourceResolver resourceResolver = persistableContentFragmentModel.getResource().getResourceResolver();
        if (resourceResolver.hasChanges()) {
            this.updateLastModified(jcrContent);
        }
        if ((persistedModel = this.getModel(resourceResolver, persistableContentFragmentModel.getBase().getId())) == null) {
            throw new PersistenceException(String.format("Updating Content Fragment Model %s failed.", persistableContentFragmentModel.getBase().getId()));
        }
        return persistedModel;
    }

    public void deleteModel(@NotNull ResourceResolver resourceResolver, @NotNull ContentFragmentModel model) throws PersistenceException {
        Resource resource = this.getContentFragmentResource(resourceResolver, model.getId());
        if (resource != null) {
            resourceResolver.delete(resource);
        }
    }

    @Nullable
    public Resource getContentFragmentResource(@NotNull ResourceResolver resourceResolver, @NotNull String id) {
        String path = Base64URLHelper.toPath(id);
        if (path == null) {
            return null;
        }
        return resourceResolver.getResource(path);
    }

    private void generateFields(CreateContentFragmentModel request, Resource modelResource) throws PersistenceException {
        Resource items;
        if (!request.getFields().isEmpty() && (items = modelResource.getChild(NN_ITEMS)) != null) {
            ModelItemsResource modelItemsResource = new ModelItemsResource(items);
            for (ContentFragmentModelField field : request.getFields()) {
                ElementTemplateWriter<ContentFragmentModelField> fieldWriter = this.fieldManagerRegistry.getWriter(field.getType());
                if (fieldWriter == null) continue;
                fieldWriter.generate(modelItemsResource, field);
            }
        }
    }

    private List<ContentFragmentModel> createModelsWithReferences(@NotNull ResourceResolver resourceResolver, @NotNull Set<String> creationOrder, @NotNull Map<String, CreateContentFragmentModel> contentFragmentModelsMap) throws PersistenceException, WCMException {
        ArrayList<ContentFragmentModel> createdModels = new ArrayList<ContentFragmentModel>();
        HashMap<String, String> createdCFMs = new HashMap<String, String>();
        for (String cfm : creationOrder) {
            CreateContentFragmentModel nextCfm = contentFragmentModelsMap.get(cfm);
            LinkedHashSet<ContentFragmentModelField> newFields = new LinkedHashSet<ContentFragmentModelField>();
            for (ContentFragmentModelField field : nextCfm.getFields()) {
                if (field.getType().equals((Object)DataType.CONTENT_FRAGMENT)) {
                    this.updateContentFragmentReferenceField(createdCFMs, (FragmentReferenceModelField)field);
                }
                newFields.add(field);
            }
            createdModels.add(this.createModel(resourceResolver, new CreateContentFragmentModel().name(nextCfm.getName()).locked(nextCfm.getLocked()).fields(new ArrayList<ContentFragmentModelField>(newFields)).configurationFolder(nextCfm.getConfigurationFolder()).description(nextCfm.getDescription()).status(nextCfm.getStatus()), false));
            createdCFMs.put(this.getPath(nextCfm.getConfigurationFolder(), nextCfm.getName()), ((ContentFragmentModel)createdModels.get(createdModels.size() - 1)).getId());
        }
        return createdModels;
    }

    private void updateContentFragmentReferenceField(Map<String, String> createdCFMs, FragmentReferenceModelField field) {
        field.setItems(field.getItems().stream().map(item -> createdCFMs.getOrDefault(item, (String)item)).collect(Collectors.toList()));
    }

    private Map<String, Set<String>> getDependencyMap(List<CreateContentFragmentModel> modelsWithoutReferences, List<CreateContentFragmentModel> modelsWithReferences) {
        HashMap<String, Set<String>> dependencyMap = new HashMap<String, Set<String>>();
        for (CreateContentFragmentModel cfm : modelsWithoutReferences) {
            dependencyMap.put(this.getPath(cfm.getConfigurationFolder(), cfm.getName()), Collections.emptySet());
        }
        for (CreateContentFragmentModel cfm : modelsWithReferences) {
            HashSet<String> dependencies = new HashSet<String>();
            for (ContentFragmentModelField field : cfm.getFields()) {
                if (!field.getType().equals((Object)DataType.CONTENT_FRAGMENT)) continue;
                dependencies.addAll(((FragmentReferenceModelField)field).getItems());
            }
            dependencyMap.put(this.getPath(cfm.getConfigurationFolder(), cfm.getName()), dependencies);
        }
        return dependencyMap;
    }

    private Set<String> getCreationOrder(Map<String, Set<String>> dependencyMap) {
        LinkedHashSet<String> orderedSet = new LinkedHashSet<String>();
        Set<Map.Entry<String, Set<String>>> dependencies = dependencyMap.entrySet();
        Iterator<Map.Entry<String, Set<String>>> dependenciesIterator = dependencies.iterator();
        while (dependenciesIterator.hasNext()) {
            Map.Entry<String, Set<String>> dependency = dependenciesIterator.next();
            if (!dependency.getValue().isEmpty()) continue;
            orderedSet.add(dependency.getKey());
            dependenciesIterator.remove();
        }
        boolean wasCFMAdded = true;
        while (wasCFMAdded) {
            wasCFMAdded = false;
            Iterator<String> modelsWithReferences = dependencyMap.keySet().iterator();
            while (modelsWithReferences.hasNext()) {
                String model = modelsWithReferences.next();
                Iterator<String> modelDependencies = dependencyMap.get(model).iterator();
                while (modelDependencies.hasNext()) {
                    String dependency = modelDependencies.next();
                    if (!orderedSet.contains(dependency)) continue;
                    modelDependencies.remove();
                    if (!dependencyMap.get(model).isEmpty()) continue;
                    orderedSet.add(model);
                    wasCFMAdded = true;
                    modelsWithReferences.remove();
                }
            }
        }
        if (!dependencyMap.isEmpty()) {
            this.generateCycleError(dependencyMap);
        }
        return orderedSet;
    }

    private void generateCycleError(Map<String, Set<String>> dependencyMap) {
        dependencyMap.keySet().removeIf(s -> ((Set)dependencyMap.get(s)).isEmpty());
        throw new ObjectIntegrityException(String.format(ERROR_MESSAGE_MODELS_CYCLE, dependencyMap.keySet()), ObjectIntegrityException.Reason.EXTERNAL, null);
    }

    private void checkDependencies(@NotNull ResourceResolver resourceResolver, Map<String, Set<String>> dependencyMap) {
        Set<String> models = dependencyMap.keySet();
        for (String model : models) {
            Iterator<String> dependenciesIterator = dependencyMap.get(model).iterator();
            while (dependenciesIterator.hasNext()) {
                String dependency = dependenciesIterator.next();
                if (models.contains(dependency)) continue;
                if (Objects.isNull(this.getModel(resourceResolver, dependency))) {
                    throw new ObjectIntegrityException(String.format(ERROR_MESSAGE_MODELS, model, dependency), ObjectIntegrityException.Reason.EXTERNAL, null);
                }
                dependenciesIterator.remove();
            }
        }
    }

    private String getPath(@Nullable String configurationFolder, String name) {
        return configurationFolder == null ? name : configurationFolder + "/" + name;
    }

    private Pair<List<CreateContentFragmentModel>, List<CreateContentFragmentModel>> splitModels(List<CreateContentFragmentModel> contentFragmentModels) {
        ArrayList<CreateContentFragmentModel> modelsWithoutReferences = new ArrayList<CreateContentFragmentModel>();
        ArrayList<CreateContentFragmentModel> modelsWithReferences = new ArrayList<CreateContentFragmentModel>();
        for (CreateContentFragmentModel requestCreateContentFragmentModel : contentFragmentModels) {
            Optional<ContentFragmentModelField> optionalReferenceField = requestCreateContentFragmentModel.getFields().stream().filter(contentFragmentModelField -> contentFragmentModelField.getType().equals((Object)DataType.CONTENT_FRAGMENT)).findFirst();
            if (optionalReferenceField.isPresent()) {
                modelsWithReferences.add(requestCreateContentFragmentModel);
                continue;
            }
            modelsWithoutReferences.add(requestCreateContentFragmentModel);
        }
        return Pair.of(modelsWithoutReferences, modelsWithReferences);
    }

    @NotNull
    private Resource createContentFragmentModelResource(@NotNull ResourceResolver resourceResolver, @NotNull String modelName, @NotNull CreateContentFragmentModel.StatusEnum status, @Nullable String description, @Nullable String configurationFolder) throws PersistenceException, WCMException {
        Resource modelResource = null;
        TemplateManager templateManager = (TemplateManager)resourceResolver.adaptTo(TemplateManager.class);
        if (templateManager != null) {
            Template baseModelTemplate;
            String name = JcrUtil.createValidName((String)modelName, (String[])JcrUtil.HYPHEN_LABEL_CHAR_MAPPING, (String)"-");
            Resource parent = this.getParentResource(resourceResolver, configurationFolder);
            ValueMapDecorator properties = new ValueMapDecorator(new HashMap());
            properties.put((Object)"jcr:title", (Object)modelName);
            properties.put((Object)PN_STATUS, (Object)status.toString());
            if (description != null) {
                properties.put((Object)"jcr:description", (Object)description);
            }
            if ((baseModelTemplate = templateManager.getTemplate(DEFAULT_MODEL_TYPE)) != null) {
                Resource baseModelResource;
                Template model = templateManager.createTemplate(parent.getPath(), DEFAULT_MODEL_TYPE, name, (ValueMap)properties);
                ModifiableValueMap modelProperties = null;
                modelResource = (Resource)model.adaptTo(Resource.class);
                if (modelResource != null) {
                    modelProperties = (ModifiableValueMap)modelResource.adaptTo(ModifiableValueMap.class);
                }
                if (modelProperties != null && (baseModelResource = (Resource)baseModelTemplate.adaptTo(Resource.class)) != null) {
                    modelProperties.computeIfAbsent((Object)"allowedPaths", key -> baseModelResource.getValueMap().get(key));
                    modelProperties.computeIfAbsent((Object)"ranking", key -> baseModelResource.getValueMap().get(key));
                    Resource modelContent = modelResource.getChild(JCR_CONTENT);
                    Resource baseModelContent = baseModelResource.getChild(JCR_CONTENT);
                    if (modelContent != null && baseModelContent != null) {
                        ModifiableValueMap modelContentProperties = (ModifiableValueMap)modelContent.adaptTo(ModifiableValueMap.class);
                        if (modelContentProperties != null) {
                            modelContentProperties.computeIfAbsent((Object)"sling:resourceType", key -> baseModelContent.getValueMap().get(key));
                            modelContentProperties.computeIfAbsent((Object)"sling:resourceSuperType", key -> baseModelContent.getValueMap().get(key));
                            Calendar now = Calendar.getInstance();
                            modelContentProperties.computeIfAbsent((Object)"jcr:createdBy", key -> resourceResolver.getUserID());
                            modelContentProperties.computeIfAbsent((Object)"jcr:created", key -> now);
                            modelContentProperties.computeIfAbsent((Object)"cq:lastModifiedBy", key -> resourceResolver.getUserID());
                            modelContentProperties.computeIfAbsent((Object)"cq:lastModified", key -> now);
                        }
                        resourceResolver.create(modelContent, NN_METADATA, Map.of("jcr:primaryType", "nt:unstructured"));
                        for (Resource baseModelContentSubResource : baseModelContent.getChildren()) {
                            resourceResolver.copy(baseModelContentSubResource.getPath(), modelContent.getPath());
                        }
                    }
                }
            } else {
                throw new PersistenceException(String.format("Missing default template %s.", DEFAULT_MODEL_TYPE));
            }
        }
        if (modelResource == null) {
            throw new PersistenceException(String.format(ERROR_MESSAGE_MODEL_NAME, modelName));
        }
        return modelResource;
    }

    @NotNull
    private Resource getParentResource(@NotNull ResourceResolver resourceResolver, @Nullable String configurationFolder) throws PersistenceException {
        Session session;
        Resource defaultParentResource;
        Resource configurationFolderResource;
        if (StringUtils.isNotEmpty((CharSequence)configurationFolder) && (configurationFolderResource = resourceResolver.getResource(configurationFolder)) != null) {
            for (String bucket : CONF_BUCKET_NAMES) {
                Resource parentResource = this.configurationResolver.getResource(configurationFolderResource, bucket, CONF_MODELS);
                if (parentResource == null) continue;
                return parentResource;
            }
        }
        if ((defaultParentResource = resourceResolver.getResource(DEFAULT_MODELS_PARENT)) == null && (session = (Session)resourceResolver.adaptTo(Session.class)) != null) {
            try {
                JcrUtil.createPath((String)DEFAULT_MODELS_PARENT, (String)"cq:Page", (String)"cq:Page", (Session)session, (boolean)true);
                defaultParentResource = resourceResolver.getResource(DEFAULT_MODELS_PARENT);
            }
            catch (RepositoryException repositoryException) {
                PersistenceException persistenceException = new PersistenceException("Cannot create Content Fragment Model.");
                LOGGER.error("Cannot create the default location for Models: {}.", (Object)DEFAULT_MODELS_PARENT, (Object)repositoryException);
                throw persistenceException;
            }
        }
        if (defaultParentResource == null) {
            PersistenceException persistenceException = new PersistenceException("Cannot create Content Fragment Model.");
            LOGGER.error("Cannot create the default location for Models: {}.", (Object)DEFAULT_MODELS_PARENT, (Object)persistenceException);
            throw persistenceException;
        }
        return defaultParentResource;
    }

    @NotNull
    public ContentFragmentModel setModelTags(@NotNull ResourceResolver resourceResolver, @NotNull ContentFragmentModel model, @NotNull Tag[] modelTags) throws PersistenceException, IllegalStateException {
        Resource modelResource = resourceResolver.getResource(model.getPath());
        Resource contentResource = modelResource.getChild(JCR_CONTENT);
        if (contentResource == null) {
            throw new IllegalStateException("Resource " + modelResource.getPath() + " has no jcr:content node.");
        }
        TagManager tagManager = (TagManager)resourceResolver.adaptTo(TagManager.class);
        if (tagManager == null) {
            throw new IllegalStateException("Can't acquire TagManager from resource (null)");
        }
        ModifiableValueMap contentProperties = (ModifiableValueMap)contentResource.adaptTo(ModifiableValueMap.class);
        if (contentProperties == null) {
            throw new IllegalStateException("User " + resourceResolver.getUserID() + " is not allowed to modify content fragment model " + model.getId() + " - " + model.getPath() + ".");
        }
        tagManager.setTags(contentResource, modelTags);
        this.updateLastModified(contentResource);
        return Objects.requireNonNull((ContentFragmentModel)modelResource.adaptTo(ContentFragmentModel.class));
    }

    private void updateLastModified(Resource contentResource) throws PersistenceException {
        ModifiableValueMap properties = (ModifiableValueMap)contentResource.adaptTo(ModifiableValueMap.class);
        properties.put((Object)"cq:lastModified", (Object)Calendar.getInstance());
        String userId = contentResource.getResourceResolver().getUserID();
        if (userId != null) {
            properties.put((Object)"cq:lastModifiedBy", (Object)userId);
        }
        try {
            ResourceResolver resourceResolver = contentResource.getResourceResolver();
            resourceResolver.commit();
        }
        catch (PersistenceException e) {
            throw new PersistenceException("Couldn't persist changes to `LastModified` data.");
        }
    }
}

