/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.ui.impl.models;

import com.adobe.cq.dam.cfm.headless.ui.HomeCardModel;
import com.adobe.granite.auth.oauth.OAuthManager;
import com.adobe.granite.auth.oauth.Provider;
import com.adobe.granite.auth.oauth.ProviderConfig;
import com.adobe.granite.auth.oauth.ProviderConfigManager;
import com.adobe.granite.toggle.api.ToggleRouter;
import com.adobe.granite.ui.components.ValueMapResourceWrapper;
import com.day.cq.commons.Externalizer;
import com.day.crx.security.token.TokenCookie;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.scribe.oauth.OAuthService;
import org.slf4j.Logger;

public abstract class AbstractHomeCardModelImpl
implements HomeCardModel {
    protected static final String AEM_STAGE_ENV = "cmstg";
    protected static final String COOKIE_CONFIG_ID = "oauth-configid";
    protected static final String CF_EDITOR_APP_PATH = "/aem/cf/editor";
    protected static final String IMS_STAGE_AUTHORIZATION_HOST = "ims-na1-stg1";
    protected static final String IMS_PROD_AUTHORIZATION_HOST = "ims-na1";
    protected static final String UNIFIED_SHELL_STAGE_ENDPOINT = "https://experience-stage.adobe.com/";
    protected static final String UNIFIED_SHELL_PROD_ENDPOINT = "https://experience.adobe.com/";

    abstract SlingHttpServletRequest getRequest();

    abstract OAuthManager getOAuthManager();

    abstract ProviderConfigManager getProviderConfigManager();

    abstract ToggleRouter getToggleRouter();

    abstract String getResourceType();

    abstract boolean isEnabled(ValueMap var1);

    abstract Logger getLogger();

    @NotNull
    String customizeInstanceUrl(@NotNull String url) {
        return url;
    }

    abstract void addPath(@NotNull StringBuilder var1);

    void customizeWrapperProperties(@NotNull ValueMap wrapperProperties) {
    }

    @Nullable
    public Resource handleWrappedResource(@NotNull SlingHttpServletRequest request) {
        Resource resource = request.getResource();
        ResourceResolver resourceResolver = resource.getResourceResolver();
        ValueMap properties = resource.getValueMap();
        ValueMapResourceWrapper wrapper = new ValueMapResourceWrapper(resource, this.getResourceType());
        ValueMap wrapperProperties = wrapper.getValueMap();
        wrapperProperties.putAll((Map)properties);
        if (this.isEnabled(properties)) {
            String aemInstanceURL;
            Externalizer externalizer = (Externalizer)resourceResolver.adaptTo(Externalizer.class);
            if (externalizer != null) {
                aemInstanceURL = externalizer.externalLink(resourceResolver, "author", "/");
                if ((aemInstanceURL = aemInstanceURL.split("://")[1]).endsWith("/")) {
                    aemInstanceURL = aemInstanceURL.substring(0, aemInstanceURL.length() - 1);
                }
            } else {
                this.getLogger().error("Externalizer could not be obtained from the resourceResolver.");
                return null;
            }
            StringBuilder href = this.getRepoPath(aemInstanceURL = this.customizeInstanceUrl(aemInstanceURL));
            if (href != null) {
                this.addPath(href);
                wrapperProperties.put((Object)"href", (Object)href.toString());
                this.customizeWrapperProperties(wrapperProperties);
                return wrapper;
            }
        }
        return null;
    }

    public StringBuilder getRepoPath(@NotNull String instancePath) {
        String unifiedShellEndpoint;
        instancePath = instancePath.split("/")[0];
        try {
            unifiedShellEndpoint = this.getUnifiedShellEndpoint();
        }
        catch (UnifiedShellException e) {
            this.getLogger().error(e.getMessage());
            unifiedShellEndpoint = this.getUnifiedShellEndpointUsingAemInstanceURL(instancePath);
        }
        if (unifiedShellEndpoint == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(unifiedShellEndpoint);
        builder.append("?repo=");
        builder.append(instancePath);
        builder.append("#");
        return builder;
    }

    private String getUnifiedShellEndpointUsingAemInstanceURL(String aemInstanceURL) {
        if (aemInstanceURL.contains("author")) {
            return aemInstanceURL.contains(AEM_STAGE_ENV) ? UNIFIED_SHELL_STAGE_ENDPOINT : UNIFIED_SHELL_PROD_ENDPOINT;
        }
        return null;
    }

    private String getUnifiedShellEndpoint() throws UnifiedShellException {
        SlingHttpServletRequest request = this.getRequest();
        String configId = TokenCookie.getCookie((HttpServletRequest)request, (String)COOKIE_CONFIG_ID);
        if (configId == null) {
            throw new UnifiedShellException("Config Id must not be null");
        }
        Provider provider = this.getOAuthManager().getProvider(configId);
        if (provider == null) {
            throw new UnifiedShellException("oAuthManager.getProvider was null");
        }
        this.getLogger().debug("oAuthManager.getProvider {}", (Object)provider);
        ProviderConfig imsConfig = this.getProviderConfigManager().getProviderConfig(configId);
        if (imsConfig == null) {
            throw new UnifiedShellException("imsConfig can not be null");
        }
        this.getLogger().debug("providerConfigManager.getProviderConfig {}", (Object)imsConfig);
        String redirectUri = imsConfig.getCallBackUrl();
        String uri = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + redirectUri;
        OAuthService oAuthService = imsConfig.getOAuthService(provider, uri);
        if (oAuthService == null) {
            throw new UnifiedShellException("OAuthService must not be null");
        }
        String authorizationUrl = oAuthService.getAuthorizationUrl(null);
        if (authorizationUrl == null) {
            throw new UnifiedShellException("Unable to obtain the authorization url, returned null");
        }
        if (authorizationUrl.contains(IMS_STAGE_AUTHORIZATION_HOST)) {
            return UNIFIED_SHELL_STAGE_ENDPOINT;
        }
        return UNIFIED_SHELL_PROD_ENDPOINT;
    }

    static class UnifiedShellException
    extends Exception {
        UnifiedShellException(String message) {
            super(message);
        }
    }
}

