/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors.versioning;

import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.headless.backend.FragmentService;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.granite.toggle.api.ToggleCondition;
import com.day.cq.dam.api.Asset;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=FT_SITES-11721)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class FragmentVersionsRestoreProcessor
implements RequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(FragmentVersionsRestoreProcessor.class);
    public static final String EXCEPTION_MSG_FORBIDDEN = "User is not allowed to restore version for this fragment.";
    static final Pattern THIS_PROCESSOR_URL_PATTERN = Pattern.compile("/" + Utils.UUID_REGEX_PATTERN_RAW + "/versions/restore/" + Utils.UUID_REGEX_PATTERN_RAW + "$", 2);
    private static final String VERSION_RESTORE = "versions/restore/";
    private static final String EXCEPTION_MSG_VERSION_RESOURCE_NOT_FOUND = "Version with id '%s' not found";
    @Reference
    private FragmentService fragmentService;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        String pathInfo = request.getPathInfo();
        if (request.isPost() && pathInfo != null && THIS_PROCESSOR_URL_PATTERN.matcher(pathInfo).matches()) {
            String id = Utils.getUuidFromRequestPath(pathInfo);
            String versionId = pathInfo.substring(pathInfo.lastIndexOf(VERSION_RESTORE) + VERSION_RESTORE.length());
            this.doRestoreVersion(request, response, id, versionId);
            return true;
        }
        return false;
    }

    public void doRestoreVersion(Request request, Response response, String id, String versionId) throws IOException {
        ResourceResolver resolver = request.getResourceResolver();
        Resource resource = Utils.getResourceByUuid(id, resolver);
        if (resource == null) {
            log.error("Resource with id '{}' could not be found", (Object)id);
            response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Content Fragment with id '%s' could not be found", id)));
            return;
        }
        Resource versionResource = Utils.getResourceByUuid(versionId, resolver);
        if (versionResource == null) {
            log.error("Version with id '{}' not found", (Object)versionId);
            response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format(EXCEPTION_MSG_VERSION_RESOURCE_NOT_FOUND, versionId)));
            return;
        }
        if (versionResource.getChild("jcr:frozenNode") == null) {
            log.error("Resource with id '{}' is not a version.", (Object)versionId);
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Resource with id '%s' is not a version.", versionId)));
            return;
        }
        ModifiableValueMap checkPermission = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        if (checkPermission == null) {
            log.error(EXCEPTION_MSG_FORBIDDEN);
            response.endWithProblem(ProblemDetails.forbidden((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)EXCEPTION_MSG_FORBIDDEN));
            return;
        }
        if (resource.getChild("jcr:content") == null) {
            log.error("Resource with id {} is not a content fragment", (Object)id);
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Resource with id '%s' is not a content fragment", id)));
            return;
        }
        ContentFragment contentFragment = (ContentFragment)resource.adaptTo(ContentFragment.class);
        if (contentFragment == null) {
            log.error("Resource with id '{}' can not be adapted to a Content Fragment.", (Object)id);
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Resource with id '%s' can not be adapted to a Content Fragment.", id)));
            return;
        }
        Asset asset = (Asset)resource.adaptTo(Asset.class);
        if (asset == null) {
            log.error("Resource is not valid.");
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Resource is not valid."));
            return;
        }
        try {
            if (contentFragment.listVersions().hasNext()) {
                boolean isFragmentRestored = this.fragmentService.restoreVersion(asset, versionId);
                if (isFragmentRestored) {
                    response.setStatus(200);
                } else {
                    log.error("Version with id '{}' not found", (Object)versionId);
                    response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Request not fulfilled."));
                }
            } else {
                log.error("The resource doesn't have any version to be restored");
                response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"The resource doesn't have any version to be restored"));
            }
        }
        catch (ContentFragmentException e) {
            log.error("Error while restoring version {}: {}", (Object)versionId, (Object)e.getMessage());
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
        }
    }
}

