/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors.versioning;

import com.adobe.aem.openapi.pagination.Cursor;
import com.adobe.aem.openapi.pagination.PaginatedItems;
import com.adobe.aem.openapi.pagination.PaginationRequestInfo;
import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.impl.FragmentServiceImpl;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.openapi.models.Version;
import com.adobe.granite.toggle.api.ToggleCondition;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=FT_SITES-11721)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class FragmentVersionsGetProcessor
implements RequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(FragmentVersionsGetProcessor.class);
    public static final String APPLICATION_JSON = "application/json";
    public static final int DEFAULT_LIMIT = 50;
    private static final String FRAGMENT_NOT_FOUND = "Fragment with ID %s was not found.";
    final Pattern thisProcessorUrlPattern = Pattern.compile("/" + Utils.UUID_REGEX_PATTERN_RAW + "/versions$", 2);
    @Reference
    private JsonDataProcessor jsonDataProcessor;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.isGet() && request.getPathInfo() != null && this.thisProcessorUrlPattern.matcher(request.getPathInfo()).matches()) {
            try {
                this.doGet(request, response);
            }
            catch (Exception e) {
                log.error("Error while processing request {}", (Object)e.getMessage());
                response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()), request.isGet());
            }
            return true;
        }
        return false;
    }

    private ContentFragment getContentFragment(Request request, Response response) throws IOException {
        ResourceResolver resolver = request.getResourceResolver();
        String id = Utils.getUuidFromRequestPath(request.getPathInfo());
        Resource resource = Utils.getResourceByUuid(id, resolver);
        if (resource == null) {
            log.error("Fragment with ID {} was not found.", (Object)id);
            response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format(FRAGMENT_NOT_FOUND, id)));
            return null;
        }
        if (resource.getChild("jcr:content") == null) {
            log.error("Resource with id {} is not a content fragment", (Object)id);
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Resource with id '%s' is not a content fragment", id)));
            return null;
        }
        ContentFragment contentFragment = (ContentFragment)resource.adaptTo(ContentFragment.class);
        if (contentFragment == null) {
            log.error("Could not adapt resource {} to a content fragment", (Object)id);
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Could not adapt resource '%s' to a content fragment", id)));
            return null;
        }
        return contentFragment;
    }

    private PaginatedItems<Version> getPaginatedVersions(PaginationRequestInfo paginationRequestInfo, ContentFragment contentFragment, ResourceResolver resourceResolver) throws ContentFragmentException {
        List versions = StreamSupport.stream(Spliterators.spliteratorUnknownSize(contentFragment.listVersions(), 16), false).map(versionDef -> FragmentServiceImpl.generateVersionFromVersionDef(versionDef, resourceResolver)).filter(Objects::nonNull).collect(Collectors.toList());
        return new PaginatedItems(versions.stream(), version -> new Cursor(version.getId().toString()), paginationRequestInfo);
    }

    private boolean arePaginatedRequestInfoValid(Request request, Response response, PaginationRequestInfo paginationRequestInfo) throws IOException {
        int limit = paginationRequestInfo.getLimit();
        if (limit == -1) {
            log.error("Invalid value for the 'limit' request parameter.");
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Invalid value for the 'limit' request parameter."), request.isGet());
            return false;
        }
        if (StringUtils.isWhitespace((String)paginationRequestInfo.getCursor())) {
            log.error("Invalid 'cursor' request parameter.");
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Invalid 'cursor' request parameter."));
            return false;
        }
        return true;
    }

    private void doGet(Request request, Response response) throws IOException, ContentFragmentException {
        PaginationRequestInfo paginationRequestInfo = new PaginationRequestInfo(request, 50);
        if (this.arePaginatedRequestInfoValid(request, response, paginationRequestInfo)) {
            ContentFragment contentFragment = this.getContentFragment(request, response);
            if (contentFragment == null) {
                return;
            }
            PaginatedItems<Version> paginatedVersion = this.getPaginatedVersions(paginationRequestInfo, contentFragment, request.getResourceResolver());
            response.setContentType(APPLICATION_JSON);
            this.jsonDataProcessor.writeValue(response.getWriter(), paginatedVersion);
        }
    }
}

