/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors.versioning;

import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.VersionDef;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.FragmentService;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentCreateVersion;
import com.adobe.granite.toggle.api.ToggleCondition;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=FT_SITES-11721)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class FragmentVersionsCreateProcessor
implements RequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(FragmentVersionsCreateProcessor.class);
    static final String LOCATION_HEADER = "/adobe/sites/cf/fragments/%s/versions/%s";
    static final Pattern THIS_PROCESSOR_URL_PATTERN = Pattern.compile("/" + Utils.UUID_REGEX_PATTERN_RAW + "/versions", 2);
    private static final String EXCEPTION_MSG_FORBIDDEN = "User is not allowed to modify tags on this fragment.";
    private static final String NOT_A_CONTENT_FRAGMENT = "Resource is not a content fragment.";
    @Reference
    private FragmentService fragmentService;
    @Reference
    private JsonDataProcessor jsonDataProcessor;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        String pathInfo = request.getPathInfo();
        if (request.isPost() && pathInfo != null && THIS_PROCESSOR_URL_PATTERN.matcher(pathInfo).matches()) {
            ContentFragmentCreateVersion contentFragmentRequest;
            String id = Utils.getUuidFromRequestPath(pathInfo);
            try {
                contentFragmentRequest = this.jsonDataProcessor.readValue((InputStream)request.getInputStream(), ContentFragmentCreateVersion.class);
            }
            catch (MismatchedInputException e) {
                contentFragmentRequest = new ContentFragmentCreateVersion();
            }
            ResourceResolver resolver = request.getResourceResolver();
            Resource resource = Utils.getResourceByUuid(id, resolver);
            if (resource == null) {
                log.error("Fragment with id '{}' not found", (Object)id);
                response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Fragment with ID %s was not found", id)));
                return true;
            }
            ModifiableValueMap checkPermission = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
            if (checkPermission == null) {
                log.error(EXCEPTION_MSG_FORBIDDEN);
                response.endWithProblem(ProblemDetails.forbidden((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)EXCEPTION_MSG_FORBIDDEN));
                return true;
            }
            if (resource.getChild("jcr:content") == null) {
                log.error("Resource with id {} is not a content fragment", (Object)id);
                response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Resource with id '%s' is not a content fragment", id)));
                return true;
            }
            ContentFragment contentFragment = (ContentFragment)resource.adaptTo(ContentFragment.class);
            if (contentFragment == null) {
                log.error("Resource could not be adapted to content fragment.");
                response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)NOT_A_CONTENT_FRAGMENT));
                return true;
            }
            try {
                VersionDef versionCreated = contentFragment.createVersion(contentFragmentRequest.getLabel(), contentFragmentRequest.getComment());
                response.setStatus(201);
                response.setHeader("Location", String.format(LOCATION_HEADER, id, versionCreated.getIdentifier()));
                return true;
            }
            catch (ContentFragmentException e) {
                log.error("Error occurred while creating version for Content Fragment with id {}: {}", (Object)id, (Object)e.getMessage());
                response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Error occurred while creating version for Content Fragment with id %s.", id)));
                return true;
            }
        }
        return false;
    }
}

