/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors.versioning;

import com.adobe.aem.openapi.services.ETagService;
import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.FragmentService;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Fragment;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.ServletResponseHelper;
import com.adobe.granite.toggle.api.ToggleCondition;
import com.adobe.granite.toggle.api.ToggleRouter;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.http.entity.ContentType;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=FT_SITES-11721)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class FragmentVersionGetProcessor
implements RequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(FragmentVersionGetProcessor.class);
    static final String EXCEPTION_MSG_NOT_A_CONTENT_FRAGMENT = "Resource could not be adapted to a content fragment";
    static final String EXCEPTION_CANNOT_ADAPT = "Failed to adapt version with the id '%s' of the content fragment";
    static final String EXCEPTION_MSG_FRAGMENT_VERSION_NOT_FOUND = "The fragment with the id '%s' does not contain any version with the id '%s'.";
    static final String EXCEPTION_MSG_VERSION_RESOURCE_NOT_FOUND = "Version with id '%s' not found";
    final Pattern thisProcessorUrlPattern = Pattern.compile("/" + Utils.UUID_REGEX_PATTERN_RAW + "/versions/" + Utils.UUID_REGEX_PATTERN_RAW + "$", 2);
    @Reference
    protected ToggleRouter toggleRouter;
    @Reference
    protected FragmentService service;
    @Reference
    protected JsonDataProcessor jsonDataProcessor;
    @Reference
    private ETagService eTagService;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.isGet() && request.getPathInfo() != null && this.thisProcessorUrlPattern.matcher(request.getPathInfo()).matches()) {
            String pathInfo = request.getPathInfo();
            if (!ServletResponseHelper.isHeaderValueMatching(request, "Accept", ContentType.APPLICATION_JSON.getMimeType())) {
                response.endWithProblem(ProblemDetails.notAcceptable((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("This endpoint requires clients to send the '%s: application/json' request header.", "Accept")));
                return true;
            }
            String fragmentId = Utils.getUuidFromRequestPath(request.getPathInfo());
            if (fragmentId == null) {
                log.error("Could not find a valid UUID");
                response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Fragment ID is not a valid UUID."));
                return true;
            }
            String versionId = pathInfo.substring(pathInfo.lastIndexOf(47) + 1);
            this.doGet(request, response, fragmentId, versionId);
            return true;
        }
        return false;
    }

    private void doGet(Request request, Response response, String fragmentId, String versionId) throws IOException {
        ResourceResolver resolver = request.getResourceResolver();
        Resource resource = Utils.getResourceByUuid(fragmentId, resolver);
        if (resource == null) {
            log.error("Fragment with id '{}' not found", (Object)fragmentId);
            response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Fragment with ID %s was not found", fragmentId)));
            return;
        }
        if (resource.getChild("jcr:content") == null) {
            log.error("Resource with id {} is not a content fragment", (Object)fragmentId);
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Resource with id '%s' is not a content fragment", fragmentId)));
            return;
        }
        ContentFragment contentFragment = (ContentFragment)resource.adaptTo(ContentFragment.class);
        if (contentFragment == null) {
            log.error("Could not adapt to content fragment");
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)EXCEPTION_MSG_NOT_A_CONTENT_FRAGMENT));
            return;
        }
        Resource versionResource = Utils.getResourceByUuid(versionId, resolver);
        if (versionResource == null) {
            log.error("Version with id '{}' not found", (Object)versionId);
            response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format(EXCEPTION_MSG_VERSION_RESOURCE_NOT_FOUND, versionId)));
            return;
        }
        Resource frozenResource = versionResource.getChild("jcr:frozenNode");
        if (frozenResource == null) {
            log.error("Resource with id '{}' is not a version.", (Object)versionId);
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Resource with id '%s' is not a version.", versionId)));
            return;
        }
        ValueMap vm = frozenResource.getValueMap();
        if (!vm.get((Object)"jcr:frozenUuid").equals(fragmentId)) {
            log.error("The fragment with the id '{}' does not contain any version with the id '{}'", (Object)fragmentId, (Object)versionId);
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format(EXCEPTION_MSG_FRAGMENT_VERSION_NOT_FOUND, fragmentId, versionId)));
            return;
        }
        Fragment fragmentVersion = this.service.getCFWithVersion(contentFragment, versionId, resolver);
        if (fragmentVersion == null) {
            log.error("Could not adapt version with id '{}' to a content fragment", (Object)versionId);
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format(EXCEPTION_CANNOT_ADAPT, versionId)));
            return;
        }
        com.adobe.cq.dam.cfm.openapi.models.ContentFragment fragmentVersionDto = fragmentVersion.convert();
        this.eTagService.setETagHeader(response, this.jsonDataProcessor.getETag(fragmentVersionDto));
        response.setContentType(ContentType.APPLICATION_JSON.getMimeType());
        this.jsonDataProcessor.writeValue(response.getWriter(), fragmentVersionDto);
    }
}

