/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors.versioning;

import com.adobe.aem.openapi.services.ETagService;
import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.FragmentService;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Fragment;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.exceptions.ETagException;
import com.adobe.granite.toggle.api.ToggleCondition;
import com.adobe.granite.toggle.api.ToggleRouter;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.jcr.AccessDeniedException;
import javax.jcr.version.VersionException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=FT_SITES-11721)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class FragmentVersionDeleteProcessor
implements RequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(FragmentVersionDeleteProcessor.class);
    public static final String NOT_A_CONTENT_FRAGMENT = "Resource is not a content fragment.";
    public static final String UNABLE_TO_OBTAIN_SESSION = "Unable to obtain session.";
    static final String IF_MATCH_HEADER_IS_NOT_PROVIDED = "If-Match Header is not provided.";
    private static final String CANT_DELETE_BASE = "Cannot delete a resource's base version.";
    private static final String EXCEPTION_MSG_VERSION_NOT_FOUND = "Could not find version with id '%s'";
    private static final String RESOURCE_NOT_FOUND = "Resource with id %s was not found";
    private static final String IF_MATCH_NOT_MATCHING = "If-Match header does not match the current ETag of the resource";
    private static final String EXCEPTION_MSG_FORBIDDEN = "User is not allowed to delete a content fragment version.";
    final Pattern thisProcessorUrlPattern = Pattern.compile("/" + Utils.UUID_REGEX_PATTERN_RAW + "/versions/" + Utils.UUID_REGEX_PATTERN_RAW + "$", 2);
    @Reference
    private ToggleRouter toggleRouter;
    @Reference
    private FragmentService service;
    @Reference
    private JsonDataProcessor jsonDataProcessor;
    @Reference
    private ETagService eTagService;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.isDelete() && request.getPathInfo() != null && this.thisProcessorUrlPattern.matcher(request.getPathInfo()).matches()) {
            this.doDelete(request, response);
            return true;
        }
        return false;
    }

    private void doDelete(Request request, Response response) throws IOException {
        String etag;
        String ifMatchHeader = request.getHeader("If-Match");
        if (ifMatchHeader == null) {
            response.endWithProblem(ProblemDetails.preconditionRequired((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)IF_MATCH_HEADER_IS_NOT_PROVIDED));
            return;
        }
        String pathInfo = request.getPathInfo();
        String id = Utils.getUuidFromRequestPath(pathInfo);
        String versionId = pathInfo.substring(pathInfo.lastIndexOf(47) + 1);
        ResourceResolver resolver = request.getResourceResolver();
        Resource resource = Utils.getResourceByUuid(id, resolver);
        if (resource == null) {
            log.error("Resource with id {} was not found", (Object)id);
            response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format(RESOURCE_NOT_FOUND, id)));
            return;
        }
        if (resource.getChild("jcr:content") == null) {
            log.error("Resource with id {} is not a content fragment", (Object)id);
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Resource with id '%s' is not a content fragment", id)));
            return;
        }
        ContentFragment contentFragment = (ContentFragment)resource.adaptTo(ContentFragment.class);
        if (contentFragment == null) {
            log.error("Resource could not be adapted to content fragment.");
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)NOT_A_CONTENT_FRAGMENT));
            return;
        }
        Resource versionResource = Utils.getResourceByUuid(versionId, resolver);
        if (versionResource == null) {
            log.error("Version with id '{}' not found", (Object)versionId);
            response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format(EXCEPTION_MSG_VERSION_NOT_FOUND, versionId)));
            return;
        }
        Resource frozenResource = versionResource.getChild("jcr:frozenNode");
        if (frozenResource == null) {
            log.error("Resource with id '{}' is not a version.", (Object)versionId);
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Resource with id '%s' is not a version.", versionId)));
            return;
        }
        ModifiableValueMap valueMap = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        Object baseVersion = valueMap.get((Object)"jcr:baseVersion");
        if (baseVersion != null && baseVersion.equals(versionId)) {
            log.error(CANT_DELETE_BASE);
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)CANT_DELETE_BASE));
            return;
        }
        try {
            Fragment fragmentDto = this.service.getCFWithVersion(contentFragment, versionId, resolver);
            if (fragmentDto == null) {
                log.error("Could not adapt version with id '{}' to a content fragment", (Object)versionId);
                response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Failed to adapt version with the id '%s' of the content fragment", versionId)));
                return;
            }
            etag = this.jsonDataProcessor.getETag(fragmentDto.convert());
        }
        catch (ETagException e) {
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
            return;
        }
        if (!this.eTagService.strongComparison(ifMatchHeader, etag)) {
            response.setHeader("ETag", etag);
            response.endWithProblem(ProblemDetails.preconditionFailed((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)IF_MATCH_NOT_MATCHING));
            return;
        }
        try {
            this.service.deleteVersion(contentFragment, versionId);
            response.setStatus(204);
        }
        catch (AccessDeniedException e) {
            log.error(EXCEPTION_MSG_FORBIDDEN);
            response.endWithProblem(ProblemDetails.forbidden((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
        }
        catch (VersionException e) {
            log.error("The content fragment version with id '{}' does not exist", (Object)versionId);
            response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("The content fragment version with id '%s' does not exist", versionId)));
        }
        catch (Exception e) {
            log.error(e.getMessage());
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
        }
    }
}

