/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors.tagging;

import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.VariationDef;
import com.adobe.cq.dam.cfm.headless.backend.FragmentService;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.openapi.models.TagList;
import com.adobe.cq.dam.cfm.tags.AbstractTagsProcessor;
import com.adobe.granite.toggle.api.ToggleCondition;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.collections.IteratorUtils;
import org.apache.http.entity.ContentType;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=FT_SITES-8257)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class FragmentVariationGetTagsProcessor
extends AbstractTagsProcessor {
    @Reference
    private FragmentService fragmentService;

    @Override
    protected String getGenericErrorMessage() {
        return "Unable to retrieve tags from Content Fragment Variation.";
    }

    @Override
    public boolean processWithExceptions(@NotNull Request request, @NotNull Response response) throws IOException, ContentFragmentException {
        if (request.getPathInfo() == null) {
            return false;
        }
        Matcher variationPatternMatcher = THIS_PROCESSOR_URL_PATTERN_VARIATIONS.matcher(request.getPathInfo());
        if (!request.isGet() || !variationPatternMatcher.matches()) {
            return false;
        }
        String variationName = this.getVariationNameFromRequest(variationPatternMatcher);
        if (variationName == null) {
            LOG.error("Couldn't extract variation name from request. Received 'null'.");
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Invalid variation name."));
            return true;
        }
        String fragmentId = Utils.getUuidFromRequestPath(request.getPathInfo());
        if (fragmentId == null) {
            LOG.error("Couldn't extract a valid resource id from request.");
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Invalid fragment id."));
            return true;
        }
        Resource contentFragmentResource = this.getFragmentResource(request, fragmentId);
        if (contentFragmentResource == null) {
            LOG.error("Resource with id '{}' could not be found", (Object)fragmentId);
            response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Content Fragment with id '%s' could not be found", fragmentId)));
            return true;
        }
        ContentFragment contentFragment = this.getContentFragment(contentFragmentResource);
        if (contentFragment == null) {
            LOG.error("Resource '{}' with id '{}' can not be adapted to a Content Fragment.", (Object)contentFragmentResource.getPath(), (Object)fragmentId);
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Content Fragment with id '%s' could not be found or it can not be adapted to a Content Fragment.", fragmentId)));
            return true;
        }
        Iterator variations = contentFragment.listAllVariations();
        Optional<VariationDef> optionalVariation = Arrays.stream(IteratorUtils.toArray((Iterator)variations)).map(var -> (VariationDef)var).filter(variation -> variationName.equals(variation.getName())).findFirst();
        if (optionalVariation.isPresent()) {
            TagList tags = this.convertTags(contentFragment.getVariationTags(variationName));
            String eTag = this.jsonDataProcessor.getETagForTags(tags);
            response.setContentType(ContentType.APPLICATION_JSON.getMimeType());
            this.eTagService.setETagHeader(response, eTag);
            response.setStatus(200);
            this.jsonDataProcessor.writeValue(response.getWriter(), tags);
        } else {
            response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)("There is no variation with the name '" + variationName + "'")));
        }
        return true;
    }
}

