/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors.tagging;

import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.VariationDef;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.exceptions.ETagException;
import com.adobe.cq.dam.cfm.tags.AbstractTagsProcessor;
import com.adobe.granite.toggle.api.ToggleCondition;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.collections.IteratorUtils;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=FT_SITES-14080)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class FragmentVariationDeleteTagsProcessor
extends AbstractTagsProcessor {
    @Override
    protected String getGenericErrorMessage() {
        return "Unable to delete tags from Content Fragment Variation.";
    }

    @Override
    protected boolean processWithExceptions(@NotNull Request request, @NotNull Response response) throws IOException, ContentFragmentException, ETagException {
        if (request.getPathInfo() == null) {
            return false;
        }
        Matcher variationPatternMatcher = THIS_PROCESSOR_URL_PATTERN_VARIATIONS.matcher(request.getPathInfo());
        if (!request.isDelete() || !variationPatternMatcher.matches()) {
            return false;
        }
        TagManager tagManager = (TagManager)request.getResourceResolver().adaptTo(TagManager.class);
        if (tagManager == null) {
            LOG.error("Unable to get TagManager from ResourceResolver.");
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"The TagManager cannot be accessed by the current session."));
            return true;
        }
        String fragmentIdFromRequest = Utils.getUuidFromRequestPath(request.getPathInfo());
        if (fragmentIdFromRequest == null) {
            LOG.error("Couldn't extract a valid resource id from request.");
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Invalid fragment id."));
            return true;
        }
        String variationName = this.getVariationNameFromRequest(variationPatternMatcher);
        if (variationName == null) {
            LOG.error("Couldn't extract variation name from request. Received 'null'.");
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Invalid variation name."));
            return true;
        }
        Resource contentFragmentResource = this.getFragmentResource(request, fragmentIdFromRequest);
        if (contentFragmentResource == null) {
            LOG.error("Resource with id '{}' could not be found.", (Object)fragmentIdFromRequest);
            response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Content Fragment with id '%s' could not be found.", fragmentIdFromRequest)));
            return true;
        }
        if (this.isNotModifiable(contentFragmentResource)) {
            LOG.error("User is not allowed to modify tags on this fragment.");
            response.endWithProblem(ProblemDetails.forbidden((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"User is not allowed to modify tags on this fragment."));
            return true;
        }
        ContentFragment contentFragment = this.getContentFragment(contentFragmentResource);
        if (contentFragment == null) {
            LOG.error("Resource '{}' with id '{}' can not be adapted to a Content Fragment.", (Object)contentFragmentResource.getPath(), (Object)fragmentIdFromRequest);
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Content Fragment with id '%s' could not be found or it can not be adapted to a Content Fragment.", fragmentIdFromRequest)));
            return true;
        }
        Iterator variations = contentFragment.listAllVariations();
        Optional<VariationDef> optionalVariation = Arrays.stream(IteratorUtils.toArray((Iterator)variations)).filter(VariationDef.class::isInstance).map(VariationDef.class::cast).filter(variation -> variationName.equals(variation.getName())).findFirst();
        if (optionalVariation.isPresent()) {
            Tag[] contentFragmentVariationTags = contentFragment.getVariationTags(optionalVariation.get().getName());
            String currentEtag = this.jsonDataProcessor.getETagForTags(this.convertTags(contentFragmentVariationTags));
            if (!this.eTagService.strongComparison(currentEtag, request.getHeader("If-Match"))) {
                response.endWithProblem(ProblemDetails.preconditionFailed((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("The latest ETag of Fragment Tag '%s' is \"%s\".", Utils.getUuidFromRequestPath(request.getPathInfo()), currentEtag)));
                return true;
            }
            if (contentFragmentVariationTags.length > 0) {
                contentFragment.setVariationTags(new Tag[0], optionalVariation.get().getName());
                request.getResourceResolver().commit();
            }
            response.setStatus(204);
        } else {
            response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)("There is no variation with the name '" + variationName + "'")));
        }
        return true;
    }
}

