/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors;

import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.FragmentService;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.backend.impl.operations.Action;
import com.adobe.cq.dam.cfm.headless.backend.impl.operations.ScheduledOperation;
import com.adobe.cq.dam.cfm.headless.backend.impl.operations.Status;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.ServletResponseHelper;
import com.adobe.cq.dam.cfm.openapi.models.ScheduledPublicationStatus;
import com.adobe.granite.toggle.api.ToggleCondition;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.regex.Pattern;
import org.apache.http.entity.ContentType;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=FT_SITES-14296)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class ScheduledPublicationStatusGetProcessor
implements RequestProcessor {
    public static final String FRAGMENT_NOT_FOUND = "Fragment with ID %s was not found";
    static final Pattern THIS_PROCESSOR_URL_PATTERN = Pattern.compile("/" + Utils.UUID_REGEX_PATTERN_RAW + "/scheduledPublicationStatus$", 2);
    @Reference
    private JsonDataProcessor jsonDataProcessor;
    @Reference
    FragmentService fragmentService;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.isGet() && request.getPathInfo() != null && THIS_PROCESSOR_URL_PATTERN.matcher(request.getPathInfo()).matches()) {
            ResourceResolver resolver;
            if (!ServletResponseHelper.isHeaderValueMatching(request, "Accept", ContentType.APPLICATION_JSON.getMimeType())) {
                response.endWithProblem(ProblemDetails.notAcceptable((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("This endpoint requires clients to send the '%s: application/json' request header.", "Accept")), true);
                return true;
            }
            String id = Utils.getUuidFromRequestPath(request.getPathInfo());
            Resource resource = Utils.getResourceByUuid(id, resolver = request.getResourceResolver());
            if (resource == null) {
                response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format(FRAGMENT_NOT_FOUND, id)));
                return true;
            }
            ScheduledOperation op = this.fragmentService.getScheduledPublicationStatus(resource);
            ScheduledPublicationStatus scheduledPublicationStatus = new ScheduledPublicationStatus();
            if (op != null) {
                scheduledPublicationStatus.setAction(this.convertAction(op.getAction()));
                scheduledPublicationStatus.setStatus(this.convertStatus(op.getStatus()));
                scheduledPublicationStatus.setScheduledBy(op.getScheduledBy());
                scheduledPublicationStatus.setScheduledDate(OffsetDateTime.parse(op.getScheduledDate()));
            }
            response.setContentType("application/json");
            this.jsonDataProcessor.writeValue(response.getWriter(), scheduledPublicationStatus);
            return true;
        }
        return false;
    }

    private ScheduledPublicationStatus.ActionEnum convertAction(Action action) {
        ScheduledPublicationStatus.ActionEnum result = null;
        switch (action) {
            case PUBLISH: {
                result = ScheduledPublicationStatus.ActionEnum.PUBLISH;
                break;
            }
            case UNPUBLISH: {
                result = ScheduledPublicationStatus.ActionEnum.UNPUBLISH;
            }
        }
        return result;
    }

    private ScheduledPublicationStatus.StatusEnum convertStatus(Status status) {
        ScheduledPublicationStatus.StatusEnum result = null;
        switch (status) {
            case PENDING: {
                result = ScheduledPublicationStatus.StatusEnum.PENDING;
                break;
            }
            case SCHEDULED: {
                result = ScheduledPublicationStatus.StatusEnum.SCHEDULED;
                break;
            }
            case QUEUED: {
                result = ScheduledPublicationStatus.StatusEnum.QUEUED;
            }
        }
        return result;
    }
}

