/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors;

import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.ReferencesListGenerator;
import com.adobe.cq.dam.cfm.headless.backend.impl.references.ReferenceInfo;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.ServletResponseHelper;
import com.adobe.cq.dam.cfm.impl.servlets.validators.RequestValidator;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentParentReference;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentParentReferenceItemsInner;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentsReferencedBy;
import com.adobe.cq.dam.cfm.openapi.models.ParentReference;
import com.adobe.cq.dam.cfm.openapi.models.ResourceStatus;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"})
public class ReferencedByPostProcessor
implements RequestProcessor {
    public static final String EXPECTED_CONTENT_TYPE = "This endpoint expects the Content-Type header to be set to %s.";
    public static final String EXPECTED_ACCEPT_HEADER = "This endpoint requires clients to send the '%s: application/json' request header.";
    private static final Logger LOG = LoggerFactory.getLogger(ReferencedByPostProcessor.class);
    private static final String PATH_REFERENCED_BY = "/referencedBy";
    @Reference
    private ReferencesListGenerator referencesListGenerator;
    @Reference
    private RequestValidator requestValidator;
    @Reference
    private JsonDataProcessor jsonDataProcessor;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.isPost() && PATH_REFERENCED_BY.equalsIgnoreCase(request.getPathInfo())) {
            try {
                if (!ServletResponseHelper.isHeaderValueMatching(request, "Content-Type", ContentType.APPLICATION_JSON.getMimeType())) {
                    response.endWithProblem(ProblemDetails.unsupportedMediaType((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format(EXPECTED_CONTENT_TYPE, "application/json")));
                    return true;
                }
                if (!ServletResponseHelper.isHeaderValueMatching(request, "Accept", ContentType.APPLICATION_JSON.getMimeType())) {
                    response.endWithProblem(ProblemDetails.notAcceptable((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format(EXPECTED_ACCEPT_HEADER, "Accept")));
                    return true;
                }
                ContentFragmentsReferencedBy payload = this.jsonDataProcessor.readValue((InputStream)request.getInputStream(), ContentFragmentsReferencedBy.class);
                List<String> validationMessages = this.requestValidator.getValidationMessages(payload);
                if (!validationMessages.isEmpty()) {
                    response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)this.requestValidator.buildValidationMessage(validationMessages)));
                    return true;
                }
                Map<String, List<ReferenceInfo>> data = this.referencesListGenerator.getReferencedBy(request.getResourceResolver(), payload.getPaths());
                ContentFragmentParentReference contentFragmentReferences = new ContentFragmentParentReference();
                ArrayList<ContentFragmentParentReferenceItemsInner> contentFragmentParentReferences = new ArrayList<ContentFragmentParentReferenceItemsInner>();
                data.forEach((path, references) -> {
                    ContentFragmentParentReferenceItemsInner contentFragmentParentReferenceInner = new ContentFragmentParentReferenceItemsInner();
                    contentFragmentParentReferenceInner.setPath((String)path);
                    contentFragmentParentReferenceInner.setParentReferences(references.stream().map(ref -> this.toParentReference((ReferenceInfo)ref, request.getResourceResolver())).collect(Collectors.toList()));
                    contentFragmentParentReferences.add(contentFragmentParentReferenceInner);
                });
                contentFragmentReferences.items(contentFragmentParentReferences);
                response.setContentType(ContentType.APPLICATION_JSON.getMimeType());
                this.jsonDataProcessor.writeValue(response.getWriter(), contentFragmentReferences);
            }
            catch (Exception e) {
                LOG.error("Payload is too large {}", (Object)e.getMessage(), (Object)e);
                response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
            }
            return true;
        }
        return false;
    }

    private ParentReference toParentReference(ReferenceInfo referenceInfo, ResourceResolver resolver) {
        Resource resource = resolver.getResource(referenceInfo.getPath());
        if (resource == null) {
            return null;
        }
        ParentReference reference = new ParentReference();
        reference.setType(ParentReference.TypeEnum.valueOf(referenceInfo.getType().toString()));
        reference.setPath(referenceInfo.getPath());
        reference.setStatus(ResourceStatus.valueOf(referenceInfo.getStatus().toString()));
        reference.setTitle(resource.getName());
        return reference;
    }
}

