/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors;

import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.FragmentConverter;
import com.adobe.cq.dam.cfm.headless.backend.LanguageCopiesProvider;
import com.adobe.cq.dam.cfm.headless.backend.impl.LanguageInfo;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.ServletResponseHelper;
import com.adobe.cq.dam.cfm.impl.servlets.validators.RequestValidator;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentLanguageCopies;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentLanguageCopiesLanguageCopiesInner;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentsTranslations;
import com.adobe.granite.toggle.api.ToggleCondition;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition-languageCopies", target="(toggle.name=ft-sites-293)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class LanguageCopiesPostProcessor
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(LanguageCopiesPostProcessor.class);
    private static final String PATH_TRANSLATIONS = "/translations";
    public static final String EXPECTED_CONTENT_TYPE = "This endpoint expects the Content-Type header to be set to %s.";
    public static final String EXPECTED_ACCEPT_HEADER = "This endpoint requires clients to send the '%s: application/json' request header.";
    @Reference
    private LanguageCopiesProvider languageCopiesProvider;
    @Reference
    private RequestValidator requestValidator;
    @Reference
    private JsonDataProcessor jsonDataProcessor;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.isPost() && PATH_TRANSLATIONS.equalsIgnoreCase(request.getPathInfo())) {
            try {
                if (!ServletResponseHelper.isHeaderValueMatching(request, "Content-Type", ContentType.APPLICATION_JSON.getMimeType())) {
                    response.endWithProblem(ProblemDetails.unsupportedMediaType((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format(EXPECTED_CONTENT_TYPE, "application/json")));
                    return true;
                }
                if (!ServletResponseHelper.isHeaderValueMatching(request, "Accept", ContentType.APPLICATION_JSON.getMimeType())) {
                    response.endWithProblem(ProblemDetails.notAcceptable((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format(EXPECTED_ACCEPT_HEADER, "Accept")));
                    return true;
                }
                ContentFragmentsTranslations contentFragmentsTranslations = this.jsonDataProcessor.readValue((InputStream)request.getInputStream(), ContentFragmentsTranslations.class);
                List<String> validationMessages = this.requestValidator.getValidationMessages(contentFragmentsTranslations);
                if (!validationMessages.isEmpty()) {
                    response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)this.requestValidator.buildValidationMessage(validationMessages)));
                    return true;
                }
                Map<String, LanguageInfo> fragmentsLanguageCopies = this.languageCopiesProvider.getLanguageInfo(request.getResourceResolver(), contentFragmentsTranslations.getPaths());
                List result = fragmentsLanguageCopies.entrySet().stream().map(entry -> new ContentFragmentLanguageCopies().path((String)entry.getKey()).locale(((LanguageInfo)entry.getValue()).getLocale()).languageCopies(((LanguageInfo)entry.getValue()).getLanguageCopies().stream().map(languageCopyDetails -> new ContentFragmentLanguageCopiesLanguageCopiesInner().locale(languageCopyDetails.getLocale()).path(languageCopyDetails.getPath()).status(FragmentConverter.convertStatus(languageCopyDetails.getStatus())).model(languageCopyDetails.getModel()).title(languageCopyDetails.getTitle())).collect(Collectors.toList()))).collect(Collectors.toUnmodifiableList());
                response.setContentType(ContentType.APPLICATION_JSON.getMimeType());
                this.jsonDataProcessor.writeValue(response.getWriter(), Map.of("items", result));
            }
            catch (Exception e) {
                LOG.error("Payload is too large {}", (Object)e.getMessage(), (Object)e);
                response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
            }
            return true;
        }
        return false;
    }
}

