/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors;

import com.adobe.aem.openapi.servlets.MIMEParser;
import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.impl.servlets.validators.RequestValidator;
import com.adobe.cq.dam.cfm.openapi.models.GraphQLRequest;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.graphql.api.engine.QueryExecutor;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.GraphQLServlet"})
public class GraphQLProcessor
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(GraphQLProcessor.class);
    private static final String GRAPHQL_EXECUTION_SYNTHETIC_RESOURCE_PATH = "/adobe/sites/cf/graphql-execution-synthetic-resource";
    private static final String IBIZA_PLANE_A = "A";
    private static final String[] selectors = new String[]{"A"};
    private static final String CONTENT_TYPE_JSON = ContentType.APPLICATION_JSON.getMimeType();
    private static final String CHARACTER_ENCODING = StandardCharsets.UTF_8.name();
    private static final String EXPECTED_CONTENT_TYPE = "This endpoint expects the Content-Type header to be set to %s.";
    private static final String EXPECTED_ACCEPT = "This endpoint requires clients to send the 'Accept: application/json' request header.";
    private static final String PARAM_QUERY = "query";
    private static final String PARAM_VARIABLES = "variables";
    @Reference
    private QueryExecutor queryExecutor;
    @Reference
    private RequestValidator requestValidator;
    @Reference
    private JsonDataProcessor jsonDataProcessor;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        if ((request.isGet() || request.isPost()) && request.getPathInfo() == null) {
            try {
                LOG.debug("Processing HTTP method {}.", (Object)request.getMethod());
                String acceptHeader = request.getHeader("Accept");
                if (StringUtils.isNotEmpty((CharSequence)acceptHeader) && !CONTENT_TYPE_JSON.equals(MIMEParser.bestMatch(List.of(CONTENT_TYPE_JSON), (String)acceptHeader))) {
                    response.endWithProblem(ProblemDetails.notAcceptable((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)EXPECTED_ACCEPT));
                    return true;
                }
                String query = null;
                Map<Object, Object> variables = Map.of();
                if (request.isPost()) {
                    String contentTypeHeader = request.getHeader("Content-Type");
                    if (StringUtils.isEmpty((CharSequence)contentTypeHeader) || !CONTENT_TYPE_JSON.equals(MIMEParser.bestMatch(List.of(CONTENT_TYPE_JSON), (String)request.getHeader("Content-Type")))) {
                        response.endWithProblem(ProblemDetails.unsupportedMediaType((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format(EXPECTED_CONTENT_TYPE, CONTENT_TYPE_JSON)));
                        return true;
                    }
                    GraphQLRequest graphQLRequest = this.jsonDataProcessor.readValue((InputStream)request.getInputStream(), GraphQLRequest.class);
                    List<String> validationMessages = this.requestValidator.getValidationMessages(graphQLRequest);
                    if (!validationMessages.isEmpty()) {
                        response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)this.requestValidator.buildValidationMessage(validationMessages)));
                        return true;
                    }
                    query = graphQLRequest.getQuery();
                    variables = graphQLRequest.getVariables();
                } else if (request.isGet()) {
                    query = request.getParameter(PARAM_QUERY);
                    if (StringUtils.isEmpty((CharSequence)query)) {
                        response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Missing 'query' request parameter."));
                        return true;
                    }
                    if (request.getParameterMap().containsKey(PARAM_VARIABLES)) {
                        variables = this.jsonDataProcessor.readValue(request.getParameter(PARAM_VARIABLES), new TypeReference<Map<String, Object>>(){});
                    }
                }
                if (StringUtils.isEmpty(query)) {
                    response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Invalid GraphQL query."));
                    return true;
                }
                SyntheticResource resource = new SyntheticResource(request.getResourceResolver(), GRAPHQL_EXECUTION_SYNTHETIC_RESOURCE_PATH, "sling:Folder");
                response.setContentType(CONTENT_TYPE_JSON);
                response.setCharacterEncoding(CHARACTER_ENCODING);
                Map executionResult = this.queryExecutor.execute(query, variables, (Resource)resource, selectors);
                this.jsonDataProcessor.writeValue(response.getWriter(), executionResult);
            }
            catch (JsonProcessingException e) {
                response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
                return true;
            }
            catch (Exception e) {
                LOG.error("Internal server error {}", (Object)e.getMessage());
                response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Internal Server Error."));
                return true;
            }
            return true;
        }
        return false;
    }
}

