/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors;

import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.impl.workflow.WorkflowContext;
import com.adobe.cq.dam.cfm.headless.backend.impl.workflow.WorkflowManager;
import com.adobe.cq.dam.cfm.headless.backend.impl.workflow.WorkflowManagerException;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.ServletResponseHelper;
import com.adobe.cq.dam.cfm.impl.servlets.validators.RequestValidator;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentPublishRequest;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentPublishResponse;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.Workflow;
import com.adobe.granite.workflow.model.WorkflowModel;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"})
public class FragmentsPublishProcessor
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(FragmentsPublishProcessor.class);
    public static final String PUBLISH_REQUEST_PATH = "/publish";
    @Reference
    private RequestValidator requestValidator;
    @Reference
    private JsonDataProcessor jsonDataProcessor;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.isPost() && PUBLISH_REQUEST_PATH.equalsIgnoreCase(request.getPathInfo())) {
            this.doPost(request, response);
            return true;
        }
        return false;
    }

    private void doPost(Request request, Response response) throws IOException {
        if (!ServletResponseHelper.isHeaderValueMatching(request, "Accept", ContentType.APPLICATION_JSON.getMimeType())) {
            response.endWithProblem(ProblemDetails.notAcceptable((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)("Invalid 'cursor' request " + String.format("This endpoint requires clients to send the '%s: application/json' request header.", "Accept"))));
            return;
        }
        try {
            ResourceResolver resourceResolver = request.getResourceResolver();
            ContentFragmentPublishRequest publishActivateRequest = this.jsonDataProcessor.readValue((InputStream)request.getInputStream(), ContentFragmentPublishRequest.class);
            if (!this.validPayload(resourceResolver, publishActivateRequest, response, request)) {
                return;
            }
            String workflowInstanceId = this.delegatePublishing(resourceResolver, publishActivateRequest);
            ContentFragmentPublishResponse publishActivateResponse = new ContentFragmentPublishResponse().workflowInstanceId(workflowInstanceId);
            response.setContentType("application/json");
            this.jsonDataProcessor.writeValue(response.getWriter(), publishActivateResponse);
        }
        catch (WorkflowManagerException e) {
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
        }
        catch (JsonParseException e) {
            LOG.error("Failed to deserialize comment from the request", (Throwable)e);
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Invalid request body format"));
        }
        catch (MismatchedInputException e) {
            LOG.error("Failed to deserialize comment from the request", (Throwable)e);
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Incomplete request body"));
        }
        catch (Exception e) {
            LOG.error("Internal server error {}", (Object)e.getMessage(), (Object)e);
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
        }
    }

    private String delegatePublishing(ResourceResolver resResolver, ContentFragmentPublishRequest request) throws WorkflowManagerException, PersistenceException {
        WorkflowContext ctx = this.createWorkflowContext(request);
        Workflow wf = WorkflowManager.createInstance(resResolver, ctx);
        return wf.getId();
    }

    private WorkflowContext createWorkflowContext(ContentFragmentPublishRequest request) throws WorkflowManagerException {
        WorkflowContext ctx = new WorkflowContext(request.getWorkflowModelId(), request.getPaths());
        String agentId = Optional.ofNullable(request.getAgentId()).orElse("publish");
        Long scheduledTime = request.getScheduledTime();
        ctx.addMetadata("absoluteTime", scheduledTime != null ? scheduledTime.longValue() : Instant.now().toEpochMilli());
        ctx.addMetadata("agentId", agentId);
        ctx.addMetadata("workflowTitle", request.getWorkflowTitle());
        List filterReferencesByStatus = request.getFilterReferencesByStatus().stream().map(filterReferencesByStatusEnum -> filterReferencesByStatusEnum.value().toLowerCase()).distinct().collect(Collectors.toUnmodifiableList());
        try {
            String includeAsString = this.jsonDataProcessor.writeValueAsString(filterReferencesByStatus);
            ctx.addMetadata("filterReferencesByStatus", includeAsString);
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable the serialize the value {}", filterReferencesByStatus);
            throw new WorkflowManagerException(String.format("Unable the serialize the value: %s", filterReferencesByStatus));
        }
        return ctx;
    }

    private boolean validPayload(ResourceResolver resResolver, ContentFragmentPublishRequest publishRequest, Response response, Request request) throws IOException {
        List<String> validationMessages = this.requestValidator.getValidationMessages(publishRequest);
        if (!validationMessages.isEmpty()) {
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)this.requestValidator.buildValidationMessage(validationMessages)));
            return false;
        }
        String id = publishRequest.getWorkflowModelId();
        try {
            WorkflowSession session = (WorkflowSession)resResolver.adaptTo(WorkflowSession.class);
            if (session == null) {
                response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Unable to obtain a workflow session."));
                return false;
            }
            WorkflowModel model = session.getModel(id);
            if (model == null) {
                response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Unknown workflow model with id %s", id)));
                return false;
            }
        }
        catch (WorkflowException ex) {
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Unknown workflow model with id: %s", id)));
            return false;
        }
        return true;
    }
}

