/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors;

import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.AllowedPermissionsListGenerator;
import com.adobe.cq.dam.cfm.headless.backend.FragmentConverter;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.ServletResponseHelper;
import com.adobe.cq.dam.cfm.impl.servlets.validators.RequestValidator;
import com.adobe.cq.dam.cfm.openapi.models.Permission;
import com.adobe.cq.dam.cfm.openapi.models.PermissionsRequest;
import com.adobe.cq.dam.cfm.openapi.models.PermissionsResponse;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"})
public class FragmentsPermissionsProcessor
implements RequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(FragmentsPermissionsProcessor.class);
    public static final String EXPECTED_CONTENT_TYPE = "This endpoint expects the Content-Type header to be set to %s.";
    public static final String EXPECTED_ACCEPT_HEADER = "This endpoint requires clients to send the '%s: application/json' request header.";
    public static final String REQUEST_PROCESSING_ERROR = "A problem encountered when processing the request, payload: {}, message: {}";
    public static final String PERMISSIONS_REQUEST_PATH = "/permissions";
    private static final String DAM_ROOT = "/content/dam/";
    @Reference
    private AllowedPermissionsListGenerator permissionsListGenerator;
    @Reference
    private JsonDataProcessor jsonDataProcessor;
    @Reference
    private RequestValidator requestValidator;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.isPost() && PERMISSIONS_REQUEST_PATH.equals(request.getPathInfo())) {
            this.doPost(request, response);
            return true;
        }
        return false;
    }

    private void doPost(@NotNull Request request, @NotNull Response response) throws IOException {
        if (!ServletResponseHelper.isHeaderValueMatching(request, "Content-Type", ContentType.APPLICATION_JSON.getMimeType())) {
            response.endWithProblem(ProblemDetails.unsupportedMediaType((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format(EXPECTED_CONTENT_TYPE, "application/json")));
            return;
        }
        if (!ServletResponseHelper.isHeaderValueMatching(request, "Accept", ContentType.APPLICATION_JSON.getMimeType())) {
            response.endWithProblem(ProblemDetails.notAcceptable((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format(EXPECTED_ACCEPT_HEADER, "Accept")));
            return;
        }
        PermissionsRequest payload = null;
        try {
            payload = this.jsonDataProcessor.readValue((InputStream)request.getInputStream(), PermissionsRequest.class);
            List<String> validationMessages = this.requestValidator.getValidationMessages(payload);
            if (!validationMessages.isEmpty()) {
                response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)this.requestValidator.buildValidationMessage(validationMessages)));
                return;
            }
            for (String string : payload.getPaths()) {
                if (string.startsWith(DAM_ROOT)) continue;
                response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("All paths must point to content fragments or folders stored under %s.", DAM_ROOT)));
                return;
            }
            ArrayList<Permission> permissions = new ArrayList<Permission>();
            if (payload.getPreferredPermissions() != null) {
                for (Permission payloadPermission : payload.getPreferredPermissions()) {
                    permissions.add(Permission.valueOf(payloadPermission.toString()));
                }
            }
            List list = this.permissionsListGenerator.getAllowedPermissions(request.getResourceResolver(), payload.getPaths(), permissions).entrySet().stream().map(entry -> new PermissionsResponse().path((String)entry.getKey()).permissions(((List)entry.getValue()).stream().flatMap(permission -> Stream.ofNullable(FragmentConverter.convertPermission(permission))).collect(Collectors.toUnmodifiableList()))).collect(Collectors.toUnmodifiableList());
            response.setContentType("application/json");
            this.jsonDataProcessor.writeValue(response.getWriter(), Map.of("items", list));
        }
        catch (JsonParseException e) {
            log.error("Failed to deserialize comment from the request", (Throwable)e);
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Invalid request body format"));
        }
        catch (MismatchedInputException e) {
            log.error("Failed to deserialize comment from the request", (Throwable)e);
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Incomplete request body"));
        }
        catch (Exception e) {
            log.error(REQUEST_PROCESSING_ERROR, new Object[]{payload, e.getMessage(), e});
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
        }
    }
}

