/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors;

import com.adobe.aem.openapi.services.ETagService;
import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.FragmentService;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Fragment;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.exceptions.ContentFragmentConflictException;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.ServletResponseHelper;
import com.adobe.cq.dam.cfm.impl.servlets.validators.FragmentValidationResult;
import com.adobe.cq.dam.cfm.impl.servlets.validators.FragmentValidator;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragment;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonPatch;
import javax.json.JsonReader;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.entity.ContentType;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"})
public class FragmentsPatchProcessor
implements RequestProcessor {
    static final String IF_MATCH_HEADER_IS_NOT_PROVIDED = "If-Match Header is not provided.";
    static final Pattern THIS_PROCESSOR_URL_PATTERN = Pattern.compile("/" + Utils.UUID_REGEX_PATTERN_RAW + "(/?)$", 2);
    private static final Logger LOG = LoggerFactory.getLogger(FragmentsPatchProcessor.class);
    private static final String APPLICATION_JSON_PATCH = "application/json-patch+json";
    private static final String HEADER_NAME_IF_MATCH = "If-Match";
    private static final String INTERNAL_SERVER_ERROR = "Internal server error {}";
    @Reference
    private FragmentService service;
    @Reference
    private ETagService eTagService;
    @Reference
    private JsonDataProcessor jsonDataProcessor;
    @Reference
    private FragmentValidator fragmentValidator;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.isPatch() && request.getPathInfo() != null && THIS_PROCESSOR_URL_PATTERN.matcher(request.getPathInfo()).matches()) {
            this.doPatch(request, response);
            return true;
        }
        return false;
    }

    protected void doPatch(Request request, Response response) throws IOException {
        String ifMatchHeader = request.getHeader(HEADER_NAME_IF_MATCH);
        if (ifMatchHeader == null) {
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)IF_MATCH_HEADER_IS_NOT_PROVIDED));
            return;
        }
        try {
            ResourceResolver resolver;
            if (!ServletResponseHelper.isHeaderValueMatching(request, "Content-Type", APPLICATION_JSON_PATCH)) {
                response.endWithProblem(ProblemDetails.unsupportedMediaType((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("This endpoints expects header Content Type to be set to %s", APPLICATION_JSON_PATCH)));
                return;
            }
            if (!ServletResponseHelper.isHeaderValueMatching(request, "Accept", ContentType.APPLICATION_JSON.getMimeType())) {
                response.endWithProblem(ProblemDetails.unsupportedMediaType((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("This endpoint requires clients to send the '%s: application/json' request header.", "Accept")), false);
                return;
            }
            String identifier = Utils.getUuidFromRequestPath(request.getPathInfo());
            Resource resource = Utils.getResourceByUuid(identifier, resolver = request.getResourceResolver());
            if (resource == null) {
                response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Fragment with ID %s was not found", identifier)));
                return;
            }
            JsonPatch patchPayload = this.getPatchPayload((HttpServletRequest)request);
            Fragment fragment = this.service.getFragment(resource);
            ContentFragment fragmentDto = fragment.convert(true);
            fragmentDto.setValidationStatus(this.fragmentValidator.validate(fragmentDto, request.getResourceResolver()).getValidationMessages());
            String etag = this.jsonDataProcessor.getETag(fragmentDto);
            if (!this.eTagService.strongComparison(ifMatchHeader, etag)) {
                this.eTagService.setETagHeader(response, etag);
                response.endWithProblem(ProblemDetails.preconditionFailed((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"If-Match header does not match the current ETag of the resource"));
                return;
            }
            ContentFragment patchedFragmentDto = this.jsonDataProcessor.applyPatch(fragmentDto, patchPayload);
            FragmentValidationResult validationResult = this.fragmentValidator.validate(patchedFragmentDto, request.getResourceResolver());
            if (!validationResult.isPartiallyValid()) {
                this.jsonDataProcessor.writeProblem(response, validationResult.convertToBadRequest());
                return;
            }
            if (!this.jsonDataProcessor.areEqual(fragmentDto, patchedFragmentDto)) {
                fragment = this.service.patchFragment(fragment, patchedFragmentDto);
                fragmentDto = fragment.convert(true);
                fragmentDto.setValidationStatus(this.fragmentValidator.validate(fragmentDto, request.getResourceResolver()).getValidationMessages());
            }
            etag = this.jsonDataProcessor.getETag(fragmentDto);
            this.eTagService.setETagHeader(response, etag);
            response.setContentType("application/json");
            this.jsonDataProcessor.writeValue(response.getWriter(), fragmentDto);
        }
        catch (JsonProcessingException | JsonException e) {
            LOG.error("Bad request {}", (Object)e.getMessage());
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
        }
        catch (ContentFragmentConflictException e) {
            LOG.error("Conflict on the content fragment request {}", (Object)e.getMessage(), (Object)e);
            response.endWithProblem(ProblemDetails.conflict((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
        }
        catch (Exception e) {
            LOG.error(INTERNAL_SERVER_ERROR, (Object)e.getMessage(), (Object)e);
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
        }
    }

    private JsonPatch getPatchPayload(HttpServletRequest request) throws IOException, JsonException {
        try (JsonReader reader = Json.createReader((InputStream)request.getInputStream());){
            JsonArray patchArray = reader.readArray();
            JsonPatch jsonPatch = Json.createPatch((JsonArray)patchArray);
            return jsonPatch;
        }
    }
}

