/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors;

import com.adobe.aem.openapi.pagination.Cursor;
import com.adobe.aem.openapi.pagination.PaginatedItems;
import com.adobe.aem.openapi.pagination.PaginationRequestInfo;
import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.FragmentService;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Fragment;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.ServletResponseHelper;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.cursors.GetFragmentsCursor;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragment;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"})
public class FragmentsGetProcessor
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(FragmentsGetProcessor.class);
    private static final String CONTENT_DAM = "/content/dam";
    private static final String PATH_PARAMETER = "path";
    static final int PAGE_MAX_SIZE_COUNT = 50;
    private static final String INTERNAL_SERVER_ERROR = "Internal server error.";
    @Reference
    private FragmentService service;
    @Reference
    private JsonDataProcessor jsonDataProcessor;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.isGet() && request.getPathInfo() == null) {
            GetFragmentsCursor getFragmentsCursor;
            if (!ServletResponseHelper.isHeaderValueMatching(request, "Accept", ContentType.APPLICATION_JSON.getMimeType())) {
                response.endWithProblem(ProblemDetails.notAcceptable((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("This endpoint requires clients to send the '%s: application/json' request header.", "Accept")), true);
                return true;
            }
            String path = request.getParameter(PATH_PARAMETER) != null ? URLDecoder.decode(request.getParameter(PATH_PARAMETER), StandardCharsets.UTF_8) : CONTENT_DAM;
            PaginationRequestInfo paginationRequestInfo = new PaginationRequestInfo(request, 50);
            if (paginationRequestInfo.getLimit() == -1) {
                response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Invalid value for 'limit' parameter."));
                return true;
            }
            if (StringUtils.isEmpty((CharSequence)paginationRequestInfo.getCursor())) {
                getFragmentsCursor = null;
            } else {
                String decodedCursor = Cursor.decode((String)paginationRequestInfo.getCursor());
                if (decodedCursor == null) {
                    response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Invalid value for 'cursor' parameter."));
                    return true;
                }
                try {
                    getFragmentsCursor = this.jsonDataProcessor.readValue(decodedCursor, GetFragmentsCursor.class);
                }
                catch (IOException e) {
                    response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Invalid value for 'cursor' parameter."));
                    return true;
                }
            }
            try {
                List<Fragment> fragments = this.service.getFragments(request.getResourceResolver(), paginationRequestInfo.getLimit() + 1, getFragmentsCursor, path);
                List list = fragments.stream().map(Fragment::convert).collect(Collectors.toList());
                PaginatedItems contentFragments = new PaginatedItems(list.stream(), this::buildCursor, paginationRequestInfo, true);
                response.setContentType("application/json");
                this.jsonDataProcessor.writeValue(response.getWriter(), contentFragments);
            }
            catch (ContentFragmentException e) {
                LOG.error(INTERNAL_SERVER_ERROR, (Throwable)e);
                response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
            }
            catch (DateTimeParseException dateTimeParseException) {
                LOG.error("Invalid value for the 'cursor' query parameter.", (Throwable)dateTimeParseException);
                response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Invalid value for the 'cursor' query parameter."));
            }
            return true;
        }
        return false;
    }

    private Cursor buildCursor(ContentFragment contentFragment) {
        GetFragmentsCursor cfCursor = GetFragmentsCursor.builder().created(contentFragment.getCreated().getAt()).uuid(contentFragment.getId()).build();
        return new Cursor(this.jsonDataProcessor.writeValueAsString(cfCursor));
    }
}

