/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors;

import com.adobe.aem.openapi.services.ETagService;
import com.adobe.aem.openapi.servlets.DefaultResponse;
import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.FragmentService;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Fragment;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Variation;
import com.adobe.cq.dam.cfm.impl.servlets.validators.FragmentValidator;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentVariation;
import com.adobe.cq.dam.cfm.openapi.models.CreateVariation;
import com.day.cq.commons.jcr.JcrUtil;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"})
public class FragmentVariationsPostProcessor
implements RequestProcessor {
    static final Pattern THIS_PROCESSOR_URL_PATTERN = Pattern.compile("/" + Utils.UUID_REGEX_PATTERN_RAW + "/variations(/?)$", 2);
    private static final String BAD_REQUEST = "Bad request {}";
    private static final String ERR_FRAGMENT_NOT_FOUND = "Fragment with ID %s was not found";
    private static final String ERR_TITLE_MISSING = "\"title\" parameter is required in the request body";
    private static final Logger LOG = LoggerFactory.getLogger(FragmentVariationsPostProcessor.class);
    private static final String INTERNAL_SERVER_ERROR = "Internal server error {}";
    @Reference
    private FragmentService fragmentService;
    @Reference
    private JsonDataProcessor jsonDataProcessor;
    @Reference
    private FragmentValidator fragmentValidator;
    @Reference
    private ETagService eTagService;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.isPost() && request.getPathInfo() != null && THIS_PROCESSOR_URL_PATTERN.matcher(request.getPathInfo()).matches()) {
            String id = Utils.getUuidFromRequestPath(request.getPathInfo());
            this.processVariationCreation(request, (HttpServletResponse)response, id);
            return true;
        }
        return false;
    }

    private void processVariationCreation(@NotNull Request request, @NotNull HttpServletResponse servletResponse, @NotNull String id) throws IOException {
        DefaultResponse response = new DefaultResponse(servletResponse);
        try {
            ResourceResolver resolver = request.getResourceResolver();
            Resource resource = Utils.getResourceByUuid(id, resolver);
            if (resource == null) {
                response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)ERR_FRAGMENT_NOT_FOUND), true);
                return;
            }
            ContentFragment contentFragment = (ContentFragment)resource.adaptTo(ContentFragment.class);
            if (contentFragment == null) {
                response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)ERR_FRAGMENT_NOT_FOUND), true);
                return;
            }
            CreateVariation payload = this.jsonDataProcessor.readValue((InputStream)request.getInputStream(), CreateVariation.class);
            String title = payload.getTitle();
            if (StringUtils.isEmpty((CharSequence)title)) {
                response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)ERR_TITLE_MISSING), true);
                return;
            }
            String variationName = this.createNameFromTitle(title, resource);
            if (variationName == null) {
                LOG.error("Unable to create a new variation name for title {}", (Object)title);
                throw new IllegalStateException("Could not create variation name");
            }
            Variation variation = this.fragmentService.createVariation(resolver, contentFragment, variationName, payload.getTitle(), payload.getDescription());
            Fragment fragment = this.fragmentService.getFragment(resource);
            ContentFragmentVariation variationDto = variation.convert();
            variationDto.setValidationStatus(this.fragmentValidator.validate(variationDto, fragment.getModel().getFields()).getValidationMessages());
            this.eTagService.setETagHeader((Response)response, this.jsonDataProcessor.getETag(variationDto));
            response.setStatus(201);
            response.setContentType("application/json");
            this.jsonDataProcessor.writeValue(response.getWriter(), variationDto);
        }
        catch (UnrecognizedPropertyException e) {
            LOG.error(BAD_REQUEST, (Object)e.getMessage(), (Object)e);
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()), true);
        }
        catch (Exception e) {
            LOG.error(INTERNAL_SERVER_ERROR, (Object)e.getMessage(), (Object)e);
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()), true);
        }
    }

    private String createNameFromTitle(@NotNull String title, @NotNull Resource cfResource) {
        return Optional.of(cfResource).map(res -> res.getChild("jcr:content/data")).map(res -> (Node)res.adaptTo(Node.class)).map(node -> {
            try {
                return JcrUtil.createValidChildName((Node)node, (String)title);
            }
            catch (RepositoryException e) {
                return null;
            }
        }).orElse(null);
    }
}

