/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors;

import com.adobe.aem.openapi.pagination.Cursor;
import com.adobe.aem.openapi.pagination.PaginatedItems;
import com.adobe.aem.openapi.pagination.PaginationRequestInfo;
import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.FragmentService;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Fragment;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Variation;
import java.io.IOException;
import java.util.List;
import java.util.Spliterators;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"})
public class FragmentVariationsGetProcessor
implements RequestProcessor {
    public static final String APPLICATION_JSON = "application/json";
    public static final int DEFAULT_LIMIT = 50;
    final Pattern THIS_PROCESSOR_URL_PATTERN = Pattern.compile("/" + Utils.UUID_REGEX_PATTERN_RAW + "/variations$", 2);
    @Reference
    private FragmentService service;
    @Reference
    private JsonDataProcessor jsonDataProcessor;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.isGet() && request.getPathInfo() != null && this.THIS_PROCESSOR_URL_PATTERN.matcher(request.getPathInfo()).matches()) {
            this.doGet(request, response);
            return true;
        }
        return false;
    }

    private void doGet(Request request, Response response) throws IOException {
        PaginationRequestInfo paginationRequestInfo = new PaginationRequestInfo(request, 50);
        int limit = paginationRequestInfo.getLimit();
        if (limit == -1) {
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Invalid value for the 'limit' request parameter."), request.isGet());
        }
        if (StringUtils.isWhitespace((String)paginationRequestInfo.getCursor())) {
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Invalid 'cursor' request parameter."));
        }
        try {
            ResourceResolver resolver = request.getResourceResolver();
            String id = Utils.getUuidFromRequestPath(request.getPathInfo());
            Resource resource = Utils.getResourceByUuid(id, resolver);
            if (resource == null) {
                response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Fragment with ID %s was not found", id)));
                return;
            }
            Fragment fragment = this.service.getFragment(resource);
            List variations = fragment.getVariations().stream().map(Variation::convert).collect(Collectors.toUnmodifiableList());
            PaginatedItems paginatedVariations = new PaginatedItems(StreamSupport.stream(Spliterators.spliteratorUnknownSize(variations.iterator(), 16), false), variation -> new Cursor(variation.getName()), paginationRequestInfo);
            response.setContentType(APPLICATION_JSON);
            this.jsonDataProcessor.writeValue(response.getWriter(), paginatedVariations);
        }
        catch (ContentFragmentException e) {
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
        }
    }
}

