/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors;

import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.VariationDef;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.FragmentSerializer;
import com.adobe.cq.dam.cfm.headless.backend.FragmentService;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.ServletResponseHelper;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.VariationConstants;
import com.adobe.cq.dam.cfm.openapi.models.BaseReference;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.IteratorUtils;
import org.apache.http.entity.ContentType;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"})
public class FragmentVariationReferenceTreeGetProcessor
implements RequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(FragmentVariationReferenceTreeGetProcessor.class);
    private final Pattern THIS_PROCESSOR_URL_PATTERN = Pattern.compile(VariationConstants.FRAGMENT_VARIATION_URL_PATTERN + "/references");
    static final String EXCEPTION_MSG_NOT_A_CONTENT_FRAGMENT = "Resource with id %s could not be adapted to a content fragment";
    @Reference
    private FragmentService fragmentService;
    @Reference
    private JsonDataProcessor jsonDataProcessor;
    @Reference
    private FragmentSerializer fragmentSerializer;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.getPathInfo() == null) {
            return false;
        }
        Matcher matcher = this.THIS_PROCESSOR_URL_PATTERN.matcher(request.getPathInfo());
        if (request.isGet() && matcher.matches()) {
            String variationName = matcher.group(matcher.groupCount());
            if (!ServletResponseHelper.isHeaderValueMatching(request, "Accept", ContentType.APPLICATION_JSON.getMimeType())) {
                response.endWithProblem(ProblemDetails.notAcceptable((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("This endpoint requires clients to send the '%s: application/json' request header.", "Accept")), true);
                return true;
            }
            this.doGet(request, response, variationName);
            return true;
        }
        return false;
    }

    private void doGet(@NotNull Request request, @NotNull Response response, String variationName) throws IOException {
        try {
            String id = Utils.getUuidFromRequestPath(request.getPathInfo());
            ResourceResolver resolver = request.getResourceResolver();
            Resource resource = Utils.getResourceByUuid(id, resolver);
            if (resource == null) {
                response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Fragment with ID %s was not found", id)));
                return;
            }
            ContentFragment contentFragment = (ContentFragment)resource.adaptTo(ContentFragment.class);
            if (contentFragment == null) {
                log.error("Resource with id {} could not be adapted to content fragment", (Object)id);
                response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format(EXCEPTION_MSG_NOT_A_CONTENT_FRAGMENT, id)));
                return;
            }
            if (!this.variationExists(contentFragment, variationName)) {
                log.error("Variation with name {} was not found", (Object)variationName);
                response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Variation with name %s was not found", variationName)));
                return;
            }
            int maxDepth = this.fragmentSerializer.getMaxReferenceRetrievalDepth();
            Set<BaseReference> variationReferences = this.fragmentService.getVariation(contentFragment, variationName, maxDepth).convertToReferences();
            response.setContentType("application/json");
            response.setHeader("X-Max-References-Depth", String.valueOf(maxDepth));
            this.jsonDataProcessor.writeValue(response.getWriter(), Map.of("items", variationReferences));
        }
        catch (Exception e) {
            log.error(e.getMessage());
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
        }
    }

    private boolean variationExists(ContentFragment contentFragment, String variationName) {
        Iterator variationDefs = contentFragment.listAllVariations();
        Optional<VariationDef> optionalVariationDef = Arrays.stream(IteratorUtils.toArray((Iterator)variationDefs)).map(var -> (VariationDef)var).filter(variation -> variationName.equals(variation.getName())).findFirst();
        return optionalVariationDef.isPresent();
    }
}

