/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors;

import com.adobe.aem.openapi.services.ETagService;
import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.FragmentService;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Fragment;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Variation;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.ServletResponseHelper;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.VariationConstants;
import com.adobe.cq.dam.cfm.impl.servlets.validators.FragmentValidationResult;
import com.adobe.cq.dam.cfm.impl.servlets.validators.FragmentValidator;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentVariation;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.regex.Matcher;
import javax.jcr.RepositoryException;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonPatch;
import javax.json.JsonReader;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.entity.ContentType;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"})
public class FragmentVariationPatchProcessor
implements RequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(FragmentVariationPatchProcessor.class);
    @Reference
    private FragmentService service;
    @Reference
    private ETagService eTagService;
    @Reference
    private JsonDataProcessor jsonDataProcessor;
    @Reference
    private FragmentValidator fragmentValidator;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.getPathInfo() == null) {
            return false;
        }
        Matcher matcher = VariationConstants.FRAGMENT_VARIATION_URL_PATTERN.matcher(request.getPathInfo());
        if (request.isPatch() && matcher.matches()) {
            String variationName = matcher.group(matcher.groupCount());
            String identifier = Utils.getUuidFromRequestPath(request.getPathInfo());
            this.doPatch(request, response, identifier, variationName);
            return true;
        }
        return false;
    }

    private void doPatch(Request request, Response response, String identifier, String variationName) throws IOException {
        String etag;
        ContentFragmentVariation variationDto;
        Fragment fragment;
        String ifMatchHeader = request.getHeader("If-Match");
        if (ifMatchHeader == null) {
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"If-Match Header is not provided."));
            return;
        }
        if (!ServletResponseHelper.isHeaderValueMatching(request, "Content-Type", "application/json-patch+json")) {
            response.endWithProblem(ProblemDetails.unsupportedMediaType((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("This endpoints expects header Content Type to be set to %s", "application/json-patch+json")));
            return;
        }
        if (!ServletResponseHelper.isHeaderValueMatching(request, "Accept", ContentType.APPLICATION_JSON.getMimeType())) {
            response.endWithProblem(ProblemDetails.unsupportedMediaType((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("This endpoint requires clients to send the '%s: application/json' request header.", "Accept")));
            return;
        }
        ResourceResolver resolver = request.getResourceResolver();
        Resource resource = Utils.getResourceByUuid(identifier, resolver);
        if (resource == null) {
            response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Fragment with ID %s was not found", identifier)));
            return;
        }
        try {
            fragment = this.service.getFragment(resource);
            Optional<Variation> optionalVariation = fragment.getVariationByName(variationName);
            if (optionalVariation.isEmpty()) {
                response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Variation with name %s was not found", variationName)));
                return;
            }
            variationDto = optionalVariation.get().convert(true);
            variationDto.setValidationStatus(this.fragmentValidator.validate(variationDto, fragment.getModel().getFields()).getValidationMessages());
            etag = this.jsonDataProcessor.getETag(variationDto);
        }
        catch (ContentFragmentException e) {
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
            return;
        }
        if (!this.eTagService.strongComparison(ifMatchHeader, etag)) {
            response.setHeader("ETag", etag);
            response.endWithProblem(ProblemDetails.preconditionFailed((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"If-Match header does not match the current ETag of the resource"));
            return;
        }
        for (int index = 0; index < fragment.getVariations().size() && !fragment.getVariations().get(index).getName().equals(variationName); ++index) {
        }
        FragmentValidationResult validationResult = null;
        try {
            JsonPatch patchPayload = this.getPatchPayload((HttpServletRequest)request);
            ContentFragmentVariation patchedVariationDto = this.jsonDataProcessor.applyPatch(variationDto, patchPayload);
            validationResult = this.fragmentValidator.validate(patchedVariationDto, fragment.getModel().getFields());
            if (!validationResult.isPartiallyValid()) {
                this.jsonDataProcessor.writeProblem(response, validationResult.convertToBadRequest());
                return;
            }
            if (!this.jsonDataProcessor.areEqual(variationDto, patchedVariationDto)) {
                variationDto = this.service.patchVariation(fragment, patchedVariationDto).convert(true);
                validationResult = this.fragmentValidator.validate(variationDto, fragment.getModel().getFields());
                variationDto.setValidationStatus(validationResult.getValidationMessages());
            }
            this.eTagService.setETagHeader(response, this.jsonDataProcessor.getETag(variationDto));
            response.setContentType("application/json");
            this.jsonDataProcessor.writeValue(response.getWriter(), variationDto);
        }
        catch (ContentFragmentException | JsonProcessingException | JsonException e) {
            log.error("Bad request when patching variation", e);
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
        }
        catch (RepositoryException e) {
            log.info("Forbidden to patch variation", (Throwable)e);
            response.endWithProblem(ProblemDetails.forbidden((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
        }
        catch (Exception e) {
            log.info("Server error when patching variation", (Throwable)e);
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
        }
    }

    private JsonPatch getPatchPayload(HttpServletRequest request) throws IOException, JsonException {
        try (JsonReader reader = Json.createReader((InputStream)request.getInputStream());){
            JsonArray patchArray = reader.readArray();
            JsonPatch jsonPatch = Json.createPatch((JsonArray)patchArray);
            return jsonPatch;
        }
    }
}

