/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors;

import com.adobe.aem.openapi.services.ETagService;
import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.FragmentSerializer;
import com.adobe.cq.dam.cfm.headless.backend.FragmentService;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Fragment;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.ServletResponseHelper;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.VariationConstants;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors.FragmentGetProcessor;
import com.adobe.cq.dam.cfm.impl.servlets.validators.FragmentValidationResult;
import com.adobe.cq.dam.cfm.impl.servlets.validators.FragmentValidator;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentVariation;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"})
public class FragmentVariationGetProcessor
implements RequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(FragmentVariationGetProcessor.class);
    @Reference
    private FragmentService service;
    @Reference
    private JsonDataProcessor jsonDataProcessor;
    @Reference
    private ETagService eTagService;
    @Reference
    private FragmentSerializer fragmentSerializer;
    @Reference
    private FragmentValidator fragmentValidator;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.getPathInfo() == null) {
            return false;
        }
        Matcher matcher = VariationConstants.FRAGMENT_VARIATION_URL_PATTERN.matcher(request.getPathInfo());
        if (request.isGet() && matcher.matches()) {
            String variationName = matcher.group(matcher.groupCount());
            String identifier = Utils.getUuidFromRequestPath(request.getPathInfo());
            this.doGet(request, response, identifier, variationName);
            return true;
        }
        return false;
    }

    private void doGet(Request request, Response response, String identifier, String variationName) throws IOException {
        if (!ServletResponseHelper.isHeaderValueMatching(request, "Accept", ContentType.APPLICATION_JSON.getMimeType())) {
            response.endWithProblem(ProblemDetails.notAcceptable((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("This endpoint requires clients to send the '%s: application/json' request header.", "Accept")));
            return;
        }
        ResourceResolver resolver = request.getResourceResolver();
        Resource resource = Utils.getResourceByUuid(identifier, resolver);
        if (resource == null) {
            log.error("Fragment with ID {} was not found", (Object)identifier);
            response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Fragment with ID %s was not found", identifier)));
            return;
        }
        try {
            int depth = 1;
            Fragment fragment = this.service.getFragment(resource, depth);
            if (fragment.getVariationByName(variationName).isEmpty()) {
                log.error("Variation with name {} was not found", (Object)variationName);
                response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Variation with name %s was not found", variationName)));
                return;
            }
            FragmentGetProcessor.References referencesRetrieval = FragmentGetProcessor.References.DIRECT_HYDRATED;
            String references = request.getParameter("references");
            if (StringUtils.isNotEmpty((CharSequence)references) && (referencesRetrieval = FragmentGetProcessor.References.fromValue(references)) == null) {
                response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Query parameter 'references' is not valid (valid values: %s)", Arrays.stream(FragmentGetProcessor.References.values()).map(FragmentGetProcessor.References::getValue).collect(Collectors.joining(", ")))));
                return;
            }
            boolean fullyHydrated = true;
            switch (referencesRetrieval) {
                case DIRECT_HYDRATED: {
                    break;
                }
                case ALL_HYDRATED: {
                    depth = this.fragmentSerializer.getMaxReferenceRetrievalDepth();
                    break;
                }
                case DIRECT: {
                    fullyHydrated = false;
                    break;
                }
                case ALL: {
                    depth = this.fragmentSerializer.getMaxReferenceRetrievalDepth();
                    fullyHydrated = false;
                }
            }
            ContentFragmentVariation variationDto = this.service.getVariation((ContentFragment)resource.adaptTo(ContentFragment.class), variationName, depth).convert(fullyHydrated);
            FragmentValidationResult validationResult = this.fragmentValidator.validate(variationDto, fragment.getModel().getFields());
            variationDto.setValidationStatus(validationResult.getValidationMessages());
            String etag = this.jsonDataProcessor.getETag(variationDto);
            this.eTagService.setETagHeader(response, etag);
            response.setContentType("application/json");
            this.jsonDataProcessor.writeValue(response.getWriter(), variationDto);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
        }
    }
}

