/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors;

import com.adobe.aem.openapi.services.ETagService;
import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.FragmentService;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Fragment;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Variation;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.VariationConstants;
import com.adobe.cq.dam.cfm.impl.servlets.validators.FragmentValidationResult;
import com.adobe.cq.dam.cfm.impl.servlets.validators.FragmentValidator;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentVariation;
import java.io.IOException;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"})
public class FragmentVariationDeleteProcessor
implements RequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(FragmentVariationDeleteProcessor.class);
    @Reference
    private FragmentService service;
    @Reference
    private ETagService eTagService;
    @Reference
    private JsonDataProcessor jsonDataProcessor;
    @Reference
    private FragmentValidator fragmentValidator;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.getPathInfo() == null) {
            return false;
        }
        Matcher matcher = VariationConstants.FRAGMENT_VARIATION_URL_PATTERN.matcher(request.getPathInfo());
        if (request.isDelete() && matcher.matches()) {
            String variationName = matcher.group(matcher.groupCount());
            String identifier = Utils.getUuidFromRequestPath(request.getPathInfo());
            this.doDelete(request, response, identifier, variationName);
            return true;
        }
        return false;
    }

    private void doDelete(Request request, Response response, String identifier, String variationName) throws IOException {
        String etag;
        Fragment fragment;
        String ifMatchHeader = request.getHeader("If-Match");
        if (ifMatchHeader == null) {
            log.error("If-Match Header is not provided.");
            response.endWithProblem(ProblemDetails.preconditionRequired((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"If-Match Header is not provided."));
            return;
        }
        ResourceResolver resolver = request.getResourceResolver();
        Resource resource = Utils.getResourceByUuid(identifier, resolver);
        if (resource == null) {
            log.error("Fragment with ID {} was not found", (Object)identifier);
            response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Fragment with ID %s was not found", identifier)));
            return;
        }
        try {
            fragment = this.service.getFragment(resource);
            Optional<Variation> optionalVariation = fragment.getVariationByName(variationName);
            if (optionalVariation.isEmpty()) {
                log.error("Variation with name {} was not found", (Object)variationName);
                response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Variation with name %s was not found", variationName)));
                return;
            }
            ContentFragmentVariation variationDto = optionalVariation.get().convert(true);
            FragmentValidationResult validationResult = this.fragmentValidator.validate(variationDto, fragment.getModel().getFields());
            variationDto.setValidationStatus(validationResult.getValidationMessages());
            etag = this.jsonDataProcessor.getETag(variationDto);
        }
        catch (ContentFragmentException e) {
            log.error(e.getMessage());
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
            return;
        }
        if (!this.eTagService.strongComparison(ifMatchHeader, etag)) {
            this.eTagService.setETagHeader(response, etag);
            log.error("If-Match header does not match the current ETag of the resource");
            response.endWithProblem(ProblemDetails.preconditionFailed((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"If-Match header does not match the current ETag of the resource"));
            return;
        }
        try {
            fragment.deleteVariation(variationName);
            resource.getResourceResolver().commit();
        }
        catch (ContentFragmentException e) {
            log.error(e.getMessage());
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
        }
        catch (PersistenceException e) {
            log.error(e.getMessage());
            response.endWithProblem(ProblemDetails.forbidden((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
        }
        response.setStatus(204);
    }
}

