/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors;

import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.FragmentSerializer;
import com.adobe.cq.dam.cfm.headless.backend.FragmentService;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Fragment;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.ServletResponseHelper;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.http.entity.ContentType;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"})
public class FragmentReferenceTreeGetProcessor
implements RequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(FragmentReferenceTreeGetProcessor.class);
    static final String MAX_DEPTH_HEADER = "X-Max-References-Depth";
    static final String FRAGMENT_ID_IS_NOT_VALID = "Fragment ID is not a valid UUID.";
    private static final String EXCEPTION_MSG_NOT_A_CONTENT_FRAGMENT = "Resource is not a content fragment";
    static final String FRAGMENT_NOT_FOUND = "Fragment with ID %s was not found";
    private static final String INTERNAL_SERVER_ERROR = "Internal server error {}";
    private static final Pattern THIS_PROCESSOR_URL_PATTERN = Pattern.compile("/" + Utils.UUID_REGEX_PATTERN_RAW + "/references$", 2);
    @Reference
    private FragmentService fragmentService;
    @Reference
    private JsonDataProcessor jsonDataProcessor;
    @Reference
    private FragmentSerializer fragmentSerializer;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.isGet() && request.getPathInfo() != null && THIS_PROCESSOR_URL_PATTERN.matcher(request.getPathInfo()).matches()) {
            if (!ServletResponseHelper.isHeaderValueMatching(request, "Accept", ContentType.APPLICATION_JSON.getMimeType())) {
                response.endWithProblem(ProblemDetails.notAcceptable((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("This endpoint requires clients to send the '%s: application/json' request header.", "Accept")), true);
                return true;
            }
            String id = Utils.getUuidFromRequestPath(request.getPathInfo());
            if (id == null) {
                response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)FRAGMENT_ID_IS_NOT_VALID));
                return true;
            }
            this.processFragmentById(request, response, id);
            return true;
        }
        return false;
    }

    private void processFragmentById(@NotNull Request request, @NotNull Response response, @NotNull String id) throws IOException {
        try {
            ResourceResolver resolver = request.getResourceResolver();
            Resource resource = Utils.getResourceByUuid(id, resolver);
            if (resource == null || resource.adaptTo(ContentFragment.class) == null) {
                response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format(FRAGMENT_NOT_FOUND, id)));
                return;
            }
            int maxDepth = this.fragmentSerializer.getMaxReferenceRetrievalDepth();
            Fragment fragment = this.fragmentService.getFragment(resource, maxDepth);
            if (fragment == null) {
                response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)EXCEPTION_MSG_NOT_A_CONTENT_FRAGMENT));
                return;
            }
            response.setContentType("application/json");
            response.setHeader(MAX_DEPTH_HEADER, Integer.toString(maxDepth));
            response.setContentType("application/json");
            this.jsonDataProcessor.writeValue(response.getWriter(), Map.of("items", fragment.convertToReferences()));
        }
        catch (Exception e) {
            log.error(INTERNAL_SERVER_ERROR, (Object)e.getMessage());
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
        }
    }
}

