/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors;

import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.FragmentTemplate;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.ServletResponseHelper;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentPreviewURL;
import com.day.cq.commons.Externalizer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"})
public class FragmentPreviewUrlProcessor
implements RequestProcessor {
    static final Pattern THIS_PROCESSOR_URL_PATTERN = Pattern.compile("/" + Utils.UUID_REGEX_PATTERN_RAW + "/previewURL(/?)$", 2);
    static final String MASTER_VARIATION_NAME = "main";
    static final String FN_EXTERNAL_PREVIEW_URL_PROP = "./externalPreviewUrlPattern";
    @Reference
    private JsonDataProcessor jsonDataProcessor;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.isGet() && request.getPathInfo() != null && THIS_PROCESSOR_URL_PATTERN.matcher(request.getPathInfo()).matches()) {
            if (!ServletResponseHelper.isHeaderValueMatching(request, "Accept", ContentType.APPLICATION_JSON.getMimeType())) {
                response.endWithProblem(ProblemDetails.unsupportedMediaType((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("This endpoint requires clients to send the '%s: application/json' request header.", "Accept")), false);
                return true;
            }
            ResourceResolver resolver = request.getResourceResolver();
            String id = Utils.getUuidFromRequestPath(request.getPathInfo());
            ContentFragment fragment = Optional.ofNullable(id).map(uuid -> Utils.getResourceByUuid(uuid, resolver)).map(resource -> (ContentFragment)resource.adaptTo(ContentFragment.class)).orElse(null);
            if (fragment == null) {
                response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Fragment with ID %s was not found", id)));
                return true;
            }
            FragmentTemplate fragmentTemplate = fragment.getTemplate();
            String pattern = this.getPublishUrlPatternFromFragmentModel(fragmentTemplate);
            Map<String, List<Object>> previewUrls = StringUtils.isEmpty((CharSequence)pattern) ? Map.of("items", List.of()) : Map.of("items", this.getFragmentPreviewUrls(fragment, fragmentTemplate, pattern, resolver));
            response.setContentType("application/json");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            this.jsonDataProcessor.writeValue(response.getWriter(), previewUrls);
            return true;
        }
        return false;
    }

    private String getPublishUrlPatternFromFragmentModel(FragmentTemplate template) {
        return Optional.ofNullable(template).map(tpl -> (Resource)tpl.adaptTo(Resource.class)).map(Resource::getValueMap).map(vm -> (String)vm.get(FN_EXTERNAL_PREVIEW_URL_PROP, String.class)).orElse(null);
    }

    private List<ContentFragmentPreviewURL> getFragmentPreviewUrls(ContentFragment fragment, FragmentTemplate model, String pattern, ResourceResolver resolver) {
        ArrayList<ContentFragmentPreviewURL> output = new ArrayList<ContentFragmentPreviewURL>();
        output.add(new ContentFragmentPreviewURL().name(MASTER_VARIATION_NAME).url(this.constructPreviewUrl(pattern, fragment, MASTER_VARIATION_NAME, model, resolver)));
        fragment.listAllVariations().forEachRemaining(variant -> output.add(new ContentFragmentPreviewURL().name(variant.getName()).url(this.constructPreviewUrl(pattern, fragment, variant.getName(), model, resolver))));
        return output;
    }

    private String constructPreviewUrl(String pattern, ContentFragment fragment, String variantName, FragmentTemplate template, ResourceResolver resolver) {
        Resource resource = (Resource)fragment.adaptTo(Resource.class);
        Resource modelResource = ((Resource)template.adaptTo(Resource.class)).getParent();
        if (resource == null) {
            return "";
        }
        Externalizer externalizer = (Externalizer)resolver.adaptTo(Externalizer.class);
        String publishUrl = Optional.ofNullable(externalizer).map(e -> e.publishLink(resolver, resource.getPath())).orElse("");
        String authorUrl = Optional.ofNullable(externalizer).map(e -> e.authorLink(resolver, resource.getPath())).orElse("");
        String localUrl = Optional.ofNullable(externalizer).map(e -> e.externalLink(resolver, "local", resource.getPath())).orElse("");
        return pattern.replace("${contentFragment.path}", resource.getPath()).replace("${contentFragment.model.path}", modelResource.getPath()).replace("${contentFragment.model.name}", modelResource.getName()).replace("${contentFragment.variation}", variantName).replace("${contentFragment.authorURL}", authorUrl).replace("${contentFragment.publishURL}", publishUrl).replace("${contentFragment.localURL}", localUrl).replace("${contentFragment.id}", (CharSequence)resource.getValueMap().get("jcr:uuid", (Object)""));
    }
}

