/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors;

import com.adobe.aem.openapi.services.ETagService;
import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.FragmentSerializer;
import com.adobe.cq.dam.cfm.headless.backend.FragmentService;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Fragment;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.ServletResponseHelper;
import com.adobe.cq.dam.cfm.impl.servlets.validators.FragmentValidationResult;
import com.adobe.cq.dam.cfm.impl.servlets.validators.FragmentValidator;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragment;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"})
public class FragmentGetProcessor
implements RequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(FragmentGetProcessor.class);
    public static final String FRAGMENT_ID_IS_NOT_VALID = "Fragment ID is not a valid UUID.";
    public static final String FRAGMENT_NOT_FOUND = "Fragment with ID %s was not found";
    private static final String EXCEPTION_MSG_NOT_A_CONTENT_FRAGMENT = "Resource is not a content fragment";
    static final Pattern THIS_PROCESSOR_URL_PATTERN = Pattern.compile("/" + Utils.UUID_REGEX_PATTERN_RAW + "(/?)$", 2);
    private static final String INTERNAL_SERVER_ERROR = "Internal server error";
    public static final String QP_REFERENCES = "references";
    @Reference
    private FragmentService service;
    @Reference
    private JsonDataProcessor jsonDataProcessor;
    @Reference
    private FragmentSerializer fragmentSerializer;
    @Reference
    private ETagService eTagService;
    @Reference
    private FragmentValidator fragmentValidator;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.isGet() && request.getPathInfo() != null && THIS_PROCESSOR_URL_PATTERN.matcher(request.getPathInfo()).matches()) {
            if (!ServletResponseHelper.isHeaderValueMatching(request, "Accept", ContentType.APPLICATION_JSON.getMimeType())) {
                response.endWithProblem(ProblemDetails.notAcceptable((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("This endpoint requires clients to send the '%s: application/json' request header.", "Accept")), true);
                return true;
            }
            String id = Utils.getUuidFromRequestPath(request.getPathInfo());
            if (id == null) {
                response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)FRAGMENT_ID_IS_NOT_VALID));
                return true;
            }
            this.processFragmentById(request, response, id);
            return true;
        }
        return false;
    }

    private void processFragmentById(Request request, Response response, String id) throws IOException {
        try {
            ResourceResolver resolver = request.getResourceResolver();
            Resource resource = Utils.getResourceByUuid(id, resolver);
            if (resource == null) {
                response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format(FRAGMENT_NOT_FOUND, id)));
                return;
            }
            References referencesRetrieval = References.DIRECT_HYDRATED;
            String references = request.getParameter(QP_REFERENCES);
            if (StringUtils.isNotEmpty((CharSequence)references) && (referencesRetrieval = References.fromValue(references)) == null) {
                response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Query parameter 'references' is not valid (valid values: %s)", Arrays.stream(References.values()).map(References::getValue).collect(Collectors.joining(", ")))));
                return;
            }
            boolean fullyHydrated = true;
            int depth = 1;
            switch (referencesRetrieval) {
                case DIRECT_HYDRATED: {
                    break;
                }
                case ALL_HYDRATED: {
                    depth = this.fragmentSerializer.getMaxReferenceRetrievalDepth();
                    break;
                }
                case DIRECT: {
                    fullyHydrated = false;
                    break;
                }
                case ALL: {
                    depth = this.fragmentSerializer.getMaxReferenceRetrievalDepth();
                    fullyHydrated = false;
                }
            }
            Fragment fragment = this.service.getFragment(resource, depth);
            if (fragment == null) {
                response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)EXCEPTION_MSG_NOT_A_CONTENT_FRAGMENT));
                return;
            }
            ContentFragment fragmentDto = fragment.convert(fullyHydrated);
            FragmentValidationResult validationResult = this.fragmentValidator.validate(fragmentDto, request.getResourceResolver());
            fragmentDto.setValidationStatus(validationResult.getValidationMessages());
            String etag = this.jsonDataProcessor.getETag(fragmentDto);
            if (this.eTagService.isClientCacheValid(request, response, etag)) {
                return;
            }
            this.eTagService.setETagHeader(response, etag);
            response.setContentType("application/json");
            this.jsonDataProcessor.writeValue(response.getWriter(), fragmentDto);
        }
        catch (Exception e) {
            log.error(INTERNAL_SERVER_ERROR, (Throwable)e);
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
        }
    }

    public static enum References {
        DIRECT("direct"),
        DIRECT_HYDRATED("direct-hydrated"),
        ALL("all"),
        ALL_HYDRATED("all-hydrated");

        private final String value;

        private References(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        @Nullable
        public static References fromValue(@NotNull String value) {
            for (References references : References.values()) {
                if (!references.getValue().equalsIgnoreCase(value)) continue;
                return references;
            }
            return null;
        }
    }
}

