/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors;

import com.adobe.aem.openapi.services.ETagService;
import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.FragmentService;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.exceptions.ETagException;
import com.adobe.cq.dam.cfm.impl.servlets.validators.FragmentValidationResult;
import com.adobe.cq.dam.cfm.impl.servlets.validators.FragmentValidator;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragment;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"})
public class FragmentDeleteProcessor
implements RequestProcessor {
    public static final String IF_MATCH_NOT_MATCHING = "If-Match header does not match the current ETag of the resource";
    static final Pattern THIS_PROCESSOR_URL_PATTERN = Pattern.compile("/" + Utils.UUID_REGEX_PATTERN_RAW, 2);
    @Reference
    private FragmentService service;
    @Reference
    private ETagService eTagService;
    @Reference
    private JsonDataProcessor jsonDataProcessor;
    @Reference
    private FragmentValidator fragmentValidator;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.isDelete() && request.getPathInfo() != null && THIS_PROCESSOR_URL_PATTERN.matcher(request.getPathInfo()).matches()) {
            try {
                String id = Utils.getUuidFromRequestPath(request.getPathInfo());
                this.doDelete(request, response, id);
            }
            catch (ContentFragmentException e) {
                response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
            }
            return true;
        }
        return false;
    }

    private void doDelete(Request request, Response response, String id) throws ContentFragmentException, IOException {
        String etag;
        String ifMatchHeader = request.getHeader("If-Match");
        if (ifMatchHeader == null) {
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"If-Match Header is not provided."));
            return;
        }
        ResourceResolver resolver = request.getResourceResolver();
        Resource resource = Utils.getResourceByUuid(id, resolver);
        if (resource == null) {
            response.setContentType("application/problem+json");
            response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("Fragment with ID %s was not found", id)));
            return;
        }
        try {
            ContentFragment fragmentDto = this.service.getFragment(resource).convert(true);
            FragmentValidationResult validationResult = this.fragmentValidator.validate(fragmentDto, request.getResourceResolver());
            fragmentDto.setValidationStatus(validationResult.getValidationMessages());
            etag = this.jsonDataProcessor.getETag(fragmentDto);
        }
        catch (ContentFragmentException | ETagException e) {
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
            return;
        }
        if (!this.eTagService.strongComparison(ifMatchHeader, etag)) {
            this.eTagService.setETagHeader(response, etag);
            response.endWithProblem(ProblemDetails.preconditionFailed((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)IF_MATCH_NOT_MATCHING));
            return;
        }
        try {
            this.service.deleteFragment(resource);
        }
        catch (ContentFragmentException e) {
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
        }
        catch (PersistenceException e) {
            response.endWithProblem(ProblemDetails.forbidden((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
        }
        response.setStatus(204);
    }
}

