/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors;

import com.adobe.aem.openapi.services.ETagService;
import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.FragmentService;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Fragment;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.exceptions.ContentFragmentConflictException;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.ServletResponseHelper;
import com.adobe.cq.dam.cfm.impl.servlets.validators.FragmentValidationResult;
import com.adobe.cq.dam.cfm.impl.servlets.validators.FragmentValidator;
import com.adobe.cq.dam.cfm.impl.servlets.validators.RequestValidator;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragment;
import com.adobe.cq.dam.cfm.openapi.models.CreateContentFragment;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import javax.jcr.RepositoryException;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"})
public class FragmentCreateProcessor
implements RequestProcessor {
    static final String THIS_PROCESSOR_URL_PATTERN = "/adobe/sites/cf/fragments";
    static final String LOCATION_HEADER = "/adobe/sites/cf/fragments/%s";
    @Reference
    private FragmentService service;
    @Reference
    private JsonDataProcessor jsonDataProcessor;
    @Reference
    private RequestValidator requestValidator;
    @Reference
    private FragmentValidator fragmentValidator;
    @Reference
    private ETagService eTagService;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.isPost() && request.getRequestURI().equals(THIS_PROCESSOR_URL_PATTERN)) {
            if (!ServletResponseHelper.isHeaderValueMatching(request, "Content-Type", ContentType.APPLICATION_JSON.getMimeType())) {
                response.endWithProblem(ProblemDetails.notAcceptable((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("This endpoint requires clients to send the '%s: application/json' request header.", "Content-Type")), true);
                return true;
            }
            try {
                CreateContentFragment contentFragmentRequest = this.jsonDataProcessor.readValue((InputStream)request.getInputStream(), CreateContentFragment.class);
                FragmentValidationResult validationResult = this.fragmentValidator.validate(contentFragmentRequest, request.getResourceResolver());
                if (!validationResult.isPartiallyValid()) {
                    this.jsonDataProcessor.writeProblem(response, validationResult.convertToBadRequest());
                    return true;
                }
                Fragment fragmentResult = this.service.createFragment(contentFragmentRequest, request.getResourceResolver());
                response.setStatus(201);
                response.setHeader("Location", String.format(LOCATION_HEADER, fragmentResult.getId()));
                response.setContentType("application/json");
                ContentFragment fragmentDto = fragmentResult.convert();
                if (fragmentDto.getId() == null) {
                    fragmentDto.setId(UUID.randomUUID());
                }
                fragmentDto.setValidationStatus(validationResult.getValidationMessages());
                this.eTagService.setETagHeader(response, this.jsonDataProcessor.getETag(fragmentDto));
                this.jsonDataProcessor.writeValue(response.getWriter(), fragmentDto);
            }
            catch (ContentFragmentConflictException e) {
                response.endWithProblem(ProblemDetails.conflict((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
            }
            catch (JsonProcessingException e) {
                response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Unable to create Content Fragment - invalid payload"));
            }
            catch (ContentFragmentException | IllegalArgumentException e) {
                response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
            }
            catch (RepositoryException e) {
                response.endWithProblem(ProblemDetails.forbidden((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
            }
            return true;
        }
        return false;
    }
}

