/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors;

import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.impl.bulkedit.FindAndReplaceService;
import com.adobe.cq.dam.cfm.headless.backend.impl.bulkedit.model.FieldValidationType;
import com.adobe.cq.dam.cfm.headless.backend.impl.bulkedit.model.ReplaceResolutionContentFragment;
import com.adobe.cq.dam.cfm.headless.backend.impl.bulkedit.model.ReplaceStatus;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.exceptions.ContentFragmentConflictException;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.ServletResponseHelper;
import com.adobe.cq.dam.cfm.impl.servlets.validators.RequestValidator;
import com.adobe.cq.dam.cfm.openapi.models.FindReplaceContentFragment;
import com.adobe.cq.dam.cfm.openapi.models.FindReplaceField;
import com.adobe.cq.dam.cfm.openapi.models.FragmentsFindAndReplaceRequest;
import com.adobe.granite.toggle.api.ToggleCondition;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=FT_SITES-5469)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class FindAndReplaceProcessor
implements RequestProcessor {
    static final String THIS_PROCESSOR_URL_PATTERN = "/adobe/sites/cf/fragments/findAndReplace";
    @Reference
    private RequestValidator requestValidator;
    @Reference
    private FindAndReplaceService findAndReplaceService;
    @Reference
    private JsonDataProcessor jsonDataProcessor;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.isPost() && request.getRequestURI().equals(THIS_PROCESSOR_URL_PATTERN)) {
            if (!ServletResponseHelper.isHeaderValueMatching(request, "Content-Type", ContentType.APPLICATION_JSON.getMimeType())) {
                response.endWithProblem(ProblemDetails.notAcceptable((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("This endpoint requires clients to send the '%s: application/json' request header.", "Content-Type")), true);
                return true;
            }
            try {
                FragmentsFindAndReplaceRequest findAndReplaceRequest = this.jsonDataProcessor.readValue((InputStream)request.getInputStream(), FragmentsFindAndReplaceRequest.class);
                List<String> optionalValidationMessage = this.requestValidator.getValidationMessages(findAndReplaceRequest);
                if (!optionalValidationMessage.isEmpty()) {
                    response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Unable to perform Find and Replace - invalid payload"));
                    return true;
                }
                List<ReplaceResolutionContentFragment> replaceResult = this.findAndReplaceService.findAndReplace(request.getResourceResolver(), findAndReplaceRequest);
                List<FindReplaceContentFragment> result = this.mapToOpenAPIGenerated(replaceResult);
                response.setContentType("application/json");
                this.jsonDataProcessor.writeValue(response.getWriter(), Map.of("items", result));
                response.setStatus(200);
            }
            catch (ContentFragmentConflictException e) {
                response.endWithProblem(ProblemDetails.conflict((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
            }
            catch (JsonProcessingException e) {
                response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Unable to create Content Fragment - invalid payload"));
            }
            catch (ContentFragmentException | IllegalArgumentException e) {
                response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
            }
            return true;
        }
        return false;
    }

    private List<FindReplaceContentFragment> mapToOpenAPIGenerated(List<ReplaceResolutionContentFragment> replaceResult) {
        return replaceResult.stream().map(elem -> {
            FindReplaceContentFragment cf = new FindReplaceContentFragment();
            cf.setPath(elem.getPath());
            cf.setFieldsInError(elem.getFieldsInError().stream().map(elemField -> {
                FindReplaceField field = new FindReplaceField();
                field.setFieldName(elemField.getFieldName());
                field.setDetails(this.translateValidationErrorDetails(elemField.getDetails()));
                return field;
            }).collect(Collectors.toList()));
            cf.setStatus(this.translateContentFragmentStatus(elem.getStatus()));
            return cf;
        }).collect(Collectors.toList());
    }

    private FindReplaceContentFragment.StatusEnum translateContentFragmentStatus(ReplaceStatus status) {
        FindReplaceContentFragment.StatusEnum outer = null;
        switch (status) {
            case OK: {
                outer = FindReplaceContentFragment.StatusEnum.OK;
                break;
            }
            case ERROR: {
                outer = FindReplaceContentFragment.StatusEnum.ERROR;
                break;
            }
            case NOT_APPLICABLE: {
                outer = FindReplaceContentFragment.StatusEnum.NOT_APPLICABLE;
            }
        }
        return outer;
    }

    private List<FindReplaceField.DetailsEnum> translateValidationErrorDetails(List<FieldValidationType> errors) {
        ArrayList<FindReplaceField.DetailsEnum> translatedStatus = new ArrayList<FindReplaceField.DetailsEnum>();
        for (FieldValidationType error : errors) {
            switch (error) {
                case REQUIRED: {
                    translatedStatus.add(FindReplaceField.DetailsEnum.REQUIRED);
                    break;
                }
                case MAX_LENGTH: {
                    translatedStatus.add(FindReplaceField.DetailsEnum.MAX_LENGTH);
                    break;
                }
                case REGEX_CUSTOM: {
                    translatedStatus.add(FindReplaceField.DetailsEnum.REGEX_CUSTOM);
                    break;
                }
                case REGEX_EMAIL: {
                    translatedStatus.add(FindReplaceField.DetailsEnum.REGEX_EMAIL);
                    break;
                }
                case REGEX_URL: {
                    translatedStatus.add(FindReplaceField.DetailsEnum.REGEX_URL);
                }
            }
        }
        return translatedStatus;
    }
}

