/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.processors;

import com.adobe.aem.openapi.pagination.PaginationRequestInfo;
import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.impl.search.ContentFragmentSearchService;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.ServletResponseHelper;
import com.adobe.cq.dam.cfm.impl.servlets.validators.RequestValidator;
import com.adobe.cq.dam.cfm.impl.servlets.validators.SearchRequestValidationResponse;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentListResult;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentSearchModel;
import com.adobe.granite.toggle.api.ToggleCondition;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.FragmentsServlet"}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=FT_SITES-11206)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class ContentFragmentSearchProcessor
implements RequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(ContentFragmentSearchProcessor.class);
    static final String THIS_PROCESSOR_PATH_INFO = "/search";
    static final String QUERY_PARAMETER_NAME = "query";
    private static final String INTERNAL_SERVER_ERROR = "Internal server error.";
    @Reference
    private RequestValidator requestValidator;
    @Reference
    private ContentFragmentSearchService searchService;
    @Reference
    private JsonDataProcessor jsonDataProcessor;

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.isGet() && request.getPathInfo() != null && request.getPathInfo().equals(THIS_PROCESSOR_PATH_INFO)) {
            String queryContent;
            ContentFragmentSearchModel searchModel;
            List<String> searchValidationMessage;
            if (!ServletResponseHelper.isHeaderValueMatching(request, "Content-Type", ContentType.APPLICATION_JSON.getMimeType())) {
                response.endWithProblem(ProblemDetails.notAcceptable((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("This endpoint requires clients to send the '%s: application/json' request header.", "Content-Type")), true);
                return true;
            }
            PaginationRequestInfo paginationRequestInfo = new PaginationRequestInfo(request, 50);
            if (paginationRequestInfo.getLimit() == -1) {
                response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Invalid value for 'limit' parameter."));
            }
            if (StringUtils.isWhitespace((CharSequence)paginationRequestInfo.getCursor())) {
                response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Invalid value for 'cursor' parameter."));
            }
            if (!(searchValidationMessage = this.requestValidator.getValidationMessages(searchModel = this.jsonDataProcessor.readValue(queryContent = URLDecoder.decode(request.getParameter(QUERY_PARAMETER_NAME), StandardCharsets.UTF_8), ContentFragmentSearchModel.class))).isEmpty()) {
                this.jsonDataProcessor.writeProblem(response, new SearchRequestValidationResponse().convertToBadRequest(searchValidationMessage));
                return true;
            }
            try {
                ContentFragmentListResult resultList = this.searchService.search(request.getResourceResolver(), searchModel, paginationRequestInfo.getCursor(), paginationRequestInfo.getLimit());
                response.setContentType("application/json");
                this.jsonDataProcessor.writeValue(response.getWriter(), resultList);
                response.setStatus(200);
            }
            catch (ContentFragmentException e) {
                log.error(INTERNAL_SERVER_ERROR, (Throwable)e);
                response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
            }
            return true;
        }
        return false;
    }
}

