/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet;

import com.adobe.cq.dam.cfm.headless.remoteapi.impl.exceptions.HeadlessServletException;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.exceptions.Message;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletPayloadHelper {
    public static final String INVALID_REQUEST_BODY_MSG = "Invalid request body format";
    public static final String INCOMPLETE_REQUEST_BODY_MSG = "Incomplete request body";
    private static final Logger LOG = LoggerFactory.getLogger(ServletPayloadHelper.class);

    private ServletPayloadHelper() {
    }

    public static <T> T getPayload(HttpServletRequest request, Class<T> toType) throws HeadlessServletException {
        try {
            return (T)new ObjectMapper().readValue((InputStream)request.getInputStream(), toType);
        }
        catch (JsonParseException e) {
            LOG.error("Failed to deserialize comment from the request", (Throwable)e);
            throw new HeadlessServletException(new Message(INVALID_REQUEST_BODY_MSG));
        }
        catch (MismatchedInputException e) {
            LOG.error("Failed to deserialize comment from the request", (Throwable)e);
            throw new HeadlessServletException(new Message(INCOMPLETE_REQUEST_BODY_MSG));
        }
        catch (IOException e) {
            throw new HeadlessServletException(new Message(e.getMessage()));
        }
    }
}

