/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.ibiza.misc;

import com.adobe.granite.toggle.api.ToggleCondition;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=ft-sites-249)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class ToggleConfigurationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToggleConfigurationManager.class);
    public static final String FEATURE_TOGGLE = "ft-sites-249";
    private static final String GRAPHQL_SERVLET_PID = "org.apache.sling.graphql.core.GraphQLServlet";
    private static final String SCHEMA_AGGREGATOR_SERVLET_PID = "org.apache.sling.graphql.schema.aggregator.SchemaAggregatorServlet";
    private static final String HEADLESS_IBIZA_PLANE_A = "headless-ibiza-plane-a";
    @Reference
    private ConfigurationAdmin configurationAdmin;

    @Activate
    void activate() {
        try {
            Configuration graphQLServletConfiguration = this.configurationAdmin.getFactoryConfiguration(GRAPHQL_SERVLET_PID, HEADLESS_IBIZA_PLANE_A, null);
            Hashtable<String, String[]> graphQLServletProperties = new Hashtable<String, String[]>();
            ((Dictionary)graphQLServletProperties).put("sling.servlet.extensions", new String[]{"json"});
            ((Dictionary)graphQLServletProperties).put("sling.servlet.selectors", new String[]{"A"});
            ((Dictionary)graphQLServletProperties).put("sling.servlet.methods", new String[]{"GET", "POST"});
            ((Dictionary)graphQLServletProperties).put("sling.servlet.resourceTypes", new String[]{"sling/servlet/default"});
            graphQLServletConfiguration.updateIfDifferent(graphQLServletProperties);
            Configuration schemaAggregatorServletConfiguration = this.configurationAdmin.getFactoryConfiguration(SCHEMA_AGGREGATOR_SERVLET_PID, HEADLESS_IBIZA_PLANE_A, null);
            Hashtable<String, String[]> schemaAggregatorServletProperties = new Hashtable<String, String[]>();
            ((Dictionary)schemaAggregatorServletProperties).put("sling.servlet.extensions", new String[]{"GQLschema"});
            ((Dictionary)schemaAggregatorServletProperties).put("sling.servlet.selectors", new String[]{"A"});
            ((Dictionary)schemaAggregatorServletProperties).put("sling.servlet.methods", new String[]{"GET"});
            ((Dictionary)schemaAggregatorServletProperties).put("sling.servlet.resourceTypes", new String[]{"sling/servlet/default"});
            ((Dictionary)schemaAggregatorServletProperties).put("selectors.to.partials.mapping", new String[]{"A:ibiza.content,cfm.schema,cf.schema"});
            schemaAggregatorServletConfiguration.updateIfDifferent(schemaAggregatorServletProperties);
        }
        catch (Exception e) {
            LOGGER.error("Unable to configure the Ibiza A plane.", (Throwable)e);
        }
    }

    @Deactivate
    void deactivate() {
        try {
            Configuration schemaAggregatorServletConfiguration;
            Configuration graphQLServletConfiguration = this.configurationAdmin.getFactoryConfiguration(GRAPHQL_SERVLET_PID, HEADLESS_IBIZA_PLANE_A, null);
            if (graphQLServletConfiguration.getProperties() != null) {
                graphQLServletConfiguration.delete();
            }
            if ((schemaAggregatorServletConfiguration = this.configurationAdmin.getFactoryConfiguration(SCHEMA_AGGREGATOR_SERVLET_PID, HEADLESS_IBIZA_PLANE_A, null)).getProperties() != null) {
                schemaAggregatorServletConfiguration.delete();
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to deactivate the Ibiza A plane.", (Throwable)e);
        }
    }
}

