/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.ibiza.contentresource;

import com.adobe.cq.dam.cfm.FragmentTemplate;
import com.adobe.cq.dam.cfm.headless.backend.Field;
import com.adobe.cq.dam.cfm.headless.backend.ModelSerializer;
import com.adobe.cq.ibiza.api.Backstage;
import com.adobe.cq.ibiza.api.ContentResource;
import com.adobe.cq.ibiza.api.Header;
import com.adobe.cq.ibiza.api.Link;
import com.adobe.cq.ibiza.api.UnstructuredContent;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentFragmentModelResource
implements ContentResource {
    private final FragmentTemplate fragmentTemplate;
    private final Resource resource;
    private volatile Header header;
    private volatile List<Map<String, Object>> fields;
    private final ModelSerializer serializer;

    public ContentFragmentModelResource(Resource resource, FragmentTemplate fragmentTemplate, ModelSerializer serializer) {
        this.resource = resource;
        this.fragmentTemplate = fragmentTemplate;
        this.serializer = serializer;
    }

    @NotNull
    public String getPath() {
        return this.resource.getPath();
    }

    @NotNull
    public List<Link> getLinks() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Header getHeader() {
        Header localHeader = this.header;
        if (this.header == null) {
            ContentFragmentModelResource contentFragmentModelResource = this;
            synchronized (contentFragmentModelResource) {
                localHeader = this.header;
                if (localHeader == null) {
                    this.header = localHeader = new Header(){

                        @Nullable
                        public String getParent() {
                            return ResourceUtil.getParent((String)ContentFragmentModelResource.this.resource.getPath());
                        }

                        @NotNull
                        public String getResourceType() {
                            return ContentFragmentModelResource.this.resource.getResourceType();
                        }

                        @Nullable
                        public String getResourceSuperType() {
                            return ContentFragmentModelResource.this.resource.getResourceSuperType();
                        }

                        @Nullable
                        public String getTitle() {
                            return ContentFragmentModelResource.this.fragmentTemplate.getTitle();
                        }

                        @Nullable
                        public String getDescription() {
                            return ContentFragmentModelResource.this.fragmentTemplate.getDescription();
                        }
                    };
                }
            }
        }
        return localHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public UnstructuredContent getBody() {
        if (this.fields == null) {
            ContentFragmentModelResource contentFragmentModelResource = this;
            synchronized (contentFragmentModelResource) {
                if (this.fields == null) {
                    List<Field> localFields = this.serializer.transform(this.fragmentTemplate);
                    ObjectMapper mapper = new ObjectMapper();
                    this.fields = localFields.stream().map(element -> (Map)mapper.convertValue(element, Map.class)).collect(Collectors.toList());
                }
            }
        }
        final List<Map<String, Object>> finalLocalFields = this.fields;
        return new UnstructuredContent(){

            @NotNull
            public String getName() {
                return "name";
            }

            @NotNull
            public String getSource() {
                return "source";
            }

            @Nullable
            public Object getContent() {
                return Map.of("fields", finalLocalFields);
            }
        };
    }

    @Nullable
    public Backstage getBackstage() {
        return null;
    }
}

