/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.ibiza.aiql;

import com.adobe.cq.ibiza.aiql.parser.AIQLParserCustomizer;
import com.adobe.cq.ibiza.aiql.parser.Visitable;
import com.adobe.cq.ibiza.aiql.parser.ast.Composite;
import com.adobe.cq.ibiza.aiql.parser.ast.Condition;
import com.adobe.cq.ibiza.aiql.parser.ast.OrderByField;
import com.adobe.cq.ibiza.aiql.parser.ast.Visitor;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ContentFragmentModelsSortingVisitor
implements Visitor,
AIQLParserCustomizer {
    static final String HEADER_TITLE = "header.title";
    static final String PATH = "path";
    private static final Set<String> ALLOWED_FIELDS = Set.of("header.title", "path");
    private static final Map<String, String> PROPERTY_TO_JCR_PROPERTY = Map.of("header.title", "@jcr:title", "path", "path");
    private final Map<String, String> providedPredicates = new LinkedHashMap<String, String>();
    private int orderByIndex = 0;

    public boolean isConditionFieldValid(String name) {
        return ALLOWED_FIELDS.contains(name);
    }

    public void visitComposite(Composite c) {
        if (c.getCompositeOperator() != Composite.CompositeOperator.SORT) {
            throw new IllegalArgumentException("Sorting cannot use the " + c.getCompositeOperator().name() + " operation.");
        }
        this.visitElements(c.getElements());
    }

    public void visitOrderByField(OrderByField f) {
        ++this.orderByIndex;
        this.providedPredicates.put(this.orderByIndex + "_orderby.orderby", PROPERTY_TO_JCR_PROPERTY.get(f.getFieldName()));
        this.providedPredicates.put(this.orderByIndex + "_orderby.sort", f.getDirection() == OrderByField.Direction.ASC ? "asc" : "desc");
    }

    private void visitElements(List<Visitable> elements) {
        for (Visitable v : elements) {
            if (v instanceof Condition) {
                throw new IllegalArgumentException("Sorting operations cannot use conditional logic.");
            }
            if (v instanceof Composite) {
                this.visitComposite((Composite)v);
            }
            if (!(v instanceof OrderByField)) continue;
            this.visitOrderByField((OrderByField)v);
        }
    }

    public Map<String, String> getPredicates() {
        return Collections.unmodifiableMap(this.providedPredicates);
    }
}

