/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.ibiza.aiql;

import com.adobe.cq.ibiza.aiql.parser.AIQLParserCustomizer;
import com.adobe.cq.ibiza.aiql.parser.Visitable;
import com.adobe.cq.ibiza.aiql.parser.ast.Composite;
import com.adobe.cq.ibiza.aiql.parser.ast.Condition;
import com.adobe.cq.ibiza.aiql.parser.ast.Visitor;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ContentFragmentModelsFilterVisitor
implements Visitor,
AIQLParserCustomizer {
    static final String HEADER_TITLE = "header.title";
    static final String HEADER_DESCRIPTION = "header.description";
    static final String HEADER_RESOURCE_TYPE = "header.resourceType";
    static final String OP_CONTAINS = "contains";
    static final String OP_CONTAINS_CASE_SENSITIVE = "containsCaseSensitive";
    static final String OP_STARTS_WITH = "startsWith";
    static final String OP_ENDS_WITH = "endsWith";
    private static final Set<String> ALLOWED_FIELDS = Set.of("header.title", "header.description", "header.resourceType");
    private static final Set<String> ALLOWED_OPERATORS = Set.of("contains", "containsCaseSensitive", "startsWith", "endsWith");
    private static final Map<String, String> OP_TO_PREDICATE = Map.of("contains", "contains", "containsCaseSensitive", "contains", "startsWith", "startsWith", "endsWith", "endsWith");
    private static final Map<String, String> PROPERTY_TO_JCR_PROPERTY = Map.of("header.title", "jcr:title", "header.description", "jcr:description", "header.resourceType", "sling:resourceType");
    private static final String PROPERTY_VALUE = "value";
    private final Map<String, String> providedPredicates = new LinkedHashMap<String, String>();
    private final Map<Integer, Integer> groupPropertyIndex = new HashMap<Integer, Integer>();
    private int groupIndex = 0;
    private boolean inOr = false;

    public void visitComposite(Composite c) {
        switch (c.getCompositeOperator()) {
            case AND: {
                this.groupPropertyIndex.putIfAbsent(this.groupIndex, 1);
                this.visitElements(c.getElements());
                break;
            }
            case OR: {
                ++this.groupIndex;
                this.groupPropertyIndex.putIfAbsent(this.groupIndex, 1);
                this.inOr = true;
                this.providedPredicates.put("group." + this.groupIndex + "_group.p.or", "true");
                this.visitElements(c.getElements());
                this.inOr = false;
            }
        }
    }

    public void visitCondition(Condition c) {
        switch (c.getOperatorName()) {
            case "contains": {
                this.groupPropertyIndex.compute(this.groupIndex, (key, value) -> value == null ? 1 : value + 1);
                this.providedPredicates.put(this.getPredicateName(OP_CONTAINS), PROPERTY_TO_JCR_PROPERTY.get(c.getFieldName()));
                this.providedPredicates.put(this.getPredicateName(OP_CONTAINS) + ".value", (String)c.getValue());
                break;
            }
            case "containsCaseSensitive": {
                this.groupPropertyIndex.compute(this.groupIndex, (key, value) -> value == null ? 1 : value + 1);
                this.providedPredicates.put(this.getPredicateName(OP_CONTAINS_CASE_SENSITIVE), PROPERTY_TO_JCR_PROPERTY.get(c.getFieldName()));
                this.providedPredicates.put(this.getPredicateName(OP_CONTAINS_CASE_SENSITIVE) + ".value", (String)c.getValue());
                this.providedPredicates.put(this.getPredicateName(OP_CONTAINS_CASE_SENSITIVE) + ".caseSensitive", "true");
                break;
            }
            case "startsWith": {
                this.groupPropertyIndex.compute(this.groupIndex, (key, value) -> value == null ? 1 : value + 1);
                this.providedPredicates.put(this.getPredicateName(OP_STARTS_WITH), PROPERTY_TO_JCR_PROPERTY.get(c.getFieldName()));
                this.providedPredicates.put(this.getPredicateName(OP_STARTS_WITH) + ".value", (String)c.getValue());
                break;
            }
            case "endsWith": {
                this.groupPropertyIndex.compute(this.groupIndex, (key, value) -> value == null ? 1 : value + 1);
                this.providedPredicates.put(this.getPredicateName(OP_ENDS_WITH), PROPERTY_TO_JCR_PROPERTY.get(c.getFieldName()));
                this.providedPredicates.put(this.getPredicateName(OP_ENDS_WITH) + ".value", (String)c.getValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operator: " + c.getOperatorName());
            }
        }
    }

    public boolean isConditionFieldValid(String name) {
        return ALLOWED_FIELDS.contains(name);
    }

    public boolean isConditionOperatorValid(String name) {
        return ALLOWED_OPERATORS.contains(name);
    }

    @NotNull
    public Map<String, String> getPredicates() {
        return Collections.unmodifiableMap(this.providedPredicates);
    }

    private void visitElements(@NotNull List<Visitable> elements) {
        for (Visitable v : elements) {
            if (v instanceof Composite) {
                this.visitComposite((Composite)v);
                continue;
            }
            if (!(v instanceof Condition)) continue;
            this.visitCondition((Condition)v);
        }
    }

    @NotNull
    private String getPredicateName(@NotNull String operator) {
        if (this.inOr) {
            return "group." + this.groupIndex + "_group." + this.groupPropertyIndex.get(this.groupIndex) + "_" + OP_TO_PREDICATE.get(operator);
        }
        return this.groupPropertyIndex.get(this.groupIndex) + "_" + OP_TO_PREDICATE.get(operator);
    }
}

