/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.ibiza;

import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.FragmentTemplate;
import com.adobe.cq.dam.cfm.headless.backend.ModelSerializer;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.ibiza.contentresource.ContentFragmentModelResource;
import com.adobe.granite.toggle.api.ToggleCondition;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.graphql.api.SlingDataFetcher;
import org.apache.sling.graphql.api.SlingDataFetcherEnvironment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SlingDataFetcher.class}, property={"name=ibiza/fetchers/contentResource/cfm"}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=ft-sites-249)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class ContentFragmentModelDataFetcher
implements SlingDataFetcher<ContentFragmentModelResource> {
    private static final Logger LOG = LoggerFactory.getLogger(ContentFragmentModelDataFetcher.class);
    @Reference
    private ModelSerializer serializer;

    @Nullable
    public ContentFragmentModelResource get(@NotNull SlingDataFetcherEnvironment e) {
        String path = (String)e.getArgument("path", (Object)"");
        Resource currentResource = e.getCurrentResource();
        if (currentResource != null) {
            Resource toFetch;
            if (path != null && !path.isEmpty() && (toFetch = currentResource.getResourceResolver().getResource(path)) != null) {
                return this.getContentFragmentModel(toFetch);
            }
            return this.getContentFragmentModel(currentResource);
        }
        return null;
    }

    @Nullable
    private ContentFragmentModelResource getContentFragmentModel(@NotNull Resource resource) {
        ContentFragment contentFragment;
        FragmentTemplate fragmentTemplate = (FragmentTemplate)resource.adaptTo(FragmentTemplate.class);
        Resource modelResource = null;
        if (fragmentTemplate != null) {
            modelResource = this.getModelResource(fragmentTemplate);
        }
        if ((contentFragment = (ContentFragment)resource.adaptTo(ContentFragment.class)) != null && (fragmentTemplate = contentFragment.getTemplate()) != null) {
            modelResource = this.getModelResource(fragmentTemplate);
        }
        if (modelResource == null || fragmentTemplate == null) {
            return null;
        }
        return new ContentFragmentModelResource(modelResource, fragmentTemplate, this.serializer);
    }

    private Resource getModelResource(FragmentTemplate fragmentTemplate) {
        Resource templateResource = (Resource)fragmentTemplate.adaptTo(Resource.class);
        if (templateResource == null) {
            LOG.warn("Can't adapt the content fragment template to resource");
            return null;
        }
        Resource parentResource = templateResource.getParent();
        if (parentResource == null) {
            LOG.warn("Can't find the parent resource of {}", (Object)templateResource.getParent());
            return null;
        }
        return parentResource;
    }
}

